package com.yeejoin.equip.eqmx;

import com.yeejoin.equip.kafka.KafkaProducerService;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data@Accessors(chain = true)
public class ConnectionConfigDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    private String id;
    private String name;
    private String communicationType;
    private String url;
    private String clientId;
    private String username;
    private String password;
    private String topics;

    private Long interval;

    /**
     * 请求方式 http
     */
    private String requestMethod;

    /**
     * 请求头 http
     */
    private String requestHeader;

    /**
     * protocols websocket
     */
    private String protocols;

    private String msgType;

    private KafkaProducerService kafkaProducerService;

    private String kafkaTopic;
}
