//package com.yeejoin.equip.kafka;
//
//import org.apache.kafka.clients.consumer.ConsumerConfig;
//import org.apache.kafka.clients.consumer.ConsumerRecords;
//import org.apache.kafka.clients.consumer.KafkaConsumer;
//import org.apache.kafka.common.serialization.StringDeserializer;
//import javax.annotation.PostConstruct;
//import java.time.Duration;
//import java.util.Collections;
//import java.util.Properties;
//import java.util.concurrent.ExecutorService;
//import java.util.concurrent.Executors;
//
///**
// * @author LiuLin
// * @date 2023年10月11日 09:31
// */
//public class WorkerConsumer {
//    private static final ExecutorService executor = Executors.newFixedThreadPool(100);
//    @PostConstruct
//    void init() throws Exception {
//        String topicName = "topic_t40";
//        KafkaConsumer<String, String> consumer = getKafkaConsumer();
//        consumer.subscribe(Collections.singletonList(topicName));
//        try {
//            while (true) {
//                ConsumerRecords<String, String> records = consumer.poll(Duration.ofSeconds(1));
//                if(!records.isEmpty()){
//                    executor.execute(new MessageHandler(records));
//                }
//            }
//        }finally {
//            consumer.close();
//        }
//    }
//
//    private static KafkaConsumer<String, String> getKafkaConsumer() {
//        Properties props = new Properties();
//        props.put("bootstrap.servers", "localhost:9092");
//        props.put(ConsumerConfig.GROUP_ID_CONFIG, "app_w");
//        props.put("client.id", "client_02");
//        props.put("enable.auto.commit", true);
//        props.put(ConsumerConfig.AUTO_OFFSET_RESET_CONFIG, "latest");
//        props.put(ConsumerConfig.KEY_DESERIALIZER_CLASS_CONFIG,   StringDeserializer.class.getName());
//        props.put(ConsumerConfig.VALUE_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class.getName());
//
//        return new KafkaConsumer<>(props);
//    }
//
//
//    static class MessageHandler implements Runnable{
//
//        private final ConsumerRecords<String, String> records;
//
//        public MessageHandler(ConsumerRecords<String, String> records) {
//            this.records = records;
//        }
//
//        @Override
//        public void run() {
//            records.forEach(record -> {
//                System.out.println(" 开始处理消息: " + record.value() + ", partition " + record.partition());
//            });
//        }
//    }
//}
