package com.yeejoin.amos.boot.module.common.api.excel;

import java.lang.annotation.*;
/**
* 导出模板数据
*/
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
public @interface ExplicitConstraint {
    //定义固定下拉内容
    String[]source()default {};
    //定义动态下拉内容，
    Class[]sourceClass()default {};
    //列标号必须和字段下标一致
	int indexNum() default 0;
	//字典type
	String type() default "";
	//接口查询
	String method() default "";
    /**
     * 设置下拉框的起始行，默认为第二行
     */
    int firstRow() default 1;

    /**
     * 设置下拉框的结束行，默认为最后一行
     */
    int lastRow() default 0x10000;
}
