package com.yeejoin.equipmanage.common.utils;


import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArrayUtil {

	@SafeVarargs
	public static <T> List<T> toArrayList(T... t) {
		return Stream.of(t).collect(Collectors.toList());
	}
	
	@SafeVarargs
	public static <T> Set<T> toSet(T... t) {
		return Stream.of(t).collect(Collectors.toSet());
	}
	
	/**
	 * list按条件过滤
	 * 
	 * @param list
	 * @param predicate
	 * @return
	 */
	public static <T> List<T> filter(final List<T> arrayList, Predicate<? super T> predicate) {
		return arrayList.stream().filter(predicate).collect(Collectors.toList());
	}
	
	/**
	 * list过滤出想要的值
	 * 
	 * @param arrayList
	 * @param predicate
	 * @return
	 */
	public static <T> T any(final List<T> arrayList, Predicate<? super T> predicate) {
		return arrayList.stream().filter(predicate).findAny().orElse(null);
	}
	
	/**
	 * 将list转换成另一个list
	 * 
	 * @param arrayList
	 * @param function
	 * @return
	 */
	public static <T, R> List<R> collect(final List<T> arrayList, Function<T, R> function) {
		return arrayList.stream().map(function).collect(Collectors.toList());
	}
	
	/**
	 * 将list转换成另一个Set
	 * 
	 * @param arrayList
	 * @param function
	 * @return
	 */
	public static <T, R> Set<R> collectSet(final List<T> arrayList, Function<T, R> function) {
		return arrayList.stream().map(function).collect(Collectors.toSet());
	}

	private ArrayUtil() {
	}
}
