package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/21
 */
@Getter
@AllArgsConstructor
public enum   HouseholdContractEnum {

    发起状态_已发起("已发起", "已发起"),
    发起状态_未发起("未发起", "未发起"),
    验证状态_已验证("已验证", "已验证"),
    验证状态_未验证("未验证", "未验证"),
    盖章状态_未盖章("未盖章", "未盖章"),
    盖章状态_已盖章("已盖章", "已盖章"),
    签字状态_已签字("已签字", "已签字"),
    签字状态_未签字("未签字", "未签字"),
    勘察状态_未勘察("未勘察", "未勘察"),
    勘察状态_已勘察("已勘察", "已勘察"),
    合同状态_未签署("未签署", "未签署"),
    合同状态_农户已签署("农户已签署", "农户已签署"),
    合同状态_双方已签署("双方已签署", "双方已签署"),
    合同状态_已作废("已作废", "已作废");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static HouseholdContractEnum getNodeByCode(String code) {
        HouseholdContractEnum powerStationNodeEnum = null;
        for(HouseholdContractEnum type: HouseholdContractEnum.values()) {
            if (type.getCode().equals(code)) {
                powerStationNodeEnum = type;
                break;
            }
        }
        return powerStationNodeEnum;
    }
}
