package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.Getter;

/**
 * 户用光伏业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum HygfRouthTypeEnum {

    /**
     * 业务类型枚举
     */
    HYGF_REPAY("hygf_repayment", "还款",10000L),
    HYGF_DZKC("hygf_dzkc", "电站勘察",10001L),
    HYGF_DSG("hygf_dsg", "待施工",10002L),
    HYGF_HTFQ("hygf_htfq", "合同发起",10003L),
    HYGF_HTQS("hygf_htqs", "合同签署",10004L),
    HYGF_HTGZ("hygf_htgz", "合同盖章",10005L),
    HYGF_XZFHD("fh_xzfhd", "新增发货单",10006L),
    HYGF_XZPGD("hygf_xzpgd", "新增派工单",10007L),
    HYGF_XZBWDJ("bw_xzbwdj", "新增并网登记",10008L),
    HYGF_XZYSTJ("ys_xzystj", "新增验收提交",10009L),
    HYGF_XZTSRZ("hygf_xztsrz", "新增推送融资",10010L),
    HYGF_BWSJSH("bw_bwsjsh", "并网设计审核",10011L),
    HYGF_BWGCSH("bw_bwgcsh", "并网工程审核",10012L),
    HYGF_YSTRSH("bw_ystrsh", "验收投融审核",10013L),
    HYGF_YSFWSH("bw_ysfwsh", "验收法务审核",10014L),
    HYGF_HTCXFQ("hygf_htcxfq", "合同重新发起",10015L),
    HYGF_DFK("hygf_dfk", "待放款",10016L),
    ;
    private final String code;

    private final String name;
    private final Long business;

    HygfRouthTypeEnum(String code, String name,Long business) {
        this.code = code;
        this.name = name;
        this.business = business;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (HygfRouthTypeEnum enumOne : HygfRouthTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
