package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 电站时间统计DTO
 */
@Data
@ApiModel(value="PowerStationTimeStatisticsDto", description="电站时间统计")
public class PowerStationTimeStatisticsDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private Long sequenceNbr;

    @ApiModelProperty(value = "电站编号")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "电站名称")
    private String ownersName;

    @ApiModelProperty(value = "电站安装规模")
    private String scale;

    @ApiModelProperty(value = "电站实际规模")
    private String realScale;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "区域公司")
    private String regionalCompaniesName;

    @ApiModelProperty(value = "经销商")
    private String serviceAgent;

    @ApiModelProperty(value = "勘察开始时间")
    private Date kcCreateTime;

    @ApiModelProperty(value = "勘察结束时间")
    private Date kcEndTime;

    @ApiModelProperty(value = "勘察停留时间")
    private String kcStopTime;

    @ApiModelProperty(value = "电子合同签约开始时间")
    private Date dzhtqyCreateTime;

    @ApiModelProperty(value = "电子合同签约结束时间")
    private Date dzhtqyEndTime;

    @ApiModelProperty(value = "电子合同签约停留时间")
    private String dzhtqyStopTime;

    @ApiModelProperty(value = "设计开始时间")
    private Date sjCreateTime;

    @ApiModelProperty(value = "设计结束时间")
    private Date sjEndTime;

    @ApiModelProperty(value = "设计停留时间")
    private String sjStopTime;

    @ApiModelProperty(value = "发货备货开始时间")
    private Date fhbhCreateTime;

    @ApiModelProperty(value = "发货备货结束时间")
    private Date fhbhEndTime;

    @ApiModelProperty(value = "发货备货停留时间")
    private String fhbhStopTime;

    @ApiModelProperty(value = "施工开始时间")
    private Date sgCreateTime;

    @ApiModelProperty(value = "施工结束时间")
    private Date sgEndTime;

    @ApiModelProperty(value = "施工停留时间")
    private String sgStopTime;

    @ApiModelProperty(value = "并网开始时间")
    private Date bwCreateTime;

    @ApiModelProperty(value = "并网结束时间")
    private Date bwEndTime;

    @ApiModelProperty(value = "并网停留时间")
    private String bwStopTime;

    @ApiModelProperty(value = "验收开始时间")
    private Date ysCreateTime;

    @ApiModelProperty(value = "验收结束时间")
    private Date ysEndTime;

    @ApiModelProperty(value = "验收停留时间")
    private String ysStopTime;

    @ApiModelProperty(value = "投融开始时间")
    private Date trCreateTime;

    @ApiModelProperty(value = "投融结束时间")
    private Date trEndTime;

    @ApiModelProperty(value = "投融停留时间")
    private String trStopTime;
}
