package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 验收整改单
 *
 * @author system_generator
 * @date 2024-01-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_acceptance_rectification_order", autoResultMap = true)
public class AcceptanceRectificationOrder extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 整改单号
     */
	@TableField("rectification_order_code")
    private String rectificationOrderCode;

    /**
     * 施工单id
     */
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站id
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 问题描述
     */
	@TableField("problem_description")
    private String problemDescription;

    /**
     * 整改状态
     */
	@TableField("rectification_status")
    private String rectificationStatus;

    /**
     * 整改描述
     */
	@TableField("rectification_description")
    private String rectificationDescription;

    /**
     * 完成日期
     */
	@TableField("complete_date")
    private Date completeDate;

    /**
     * 负责人ID
     */
	@TableField("responsible_user_id")
    private Long responsibleUserId;

    /**
     * 负责人姓名
     */
	@TableField("responsible_user_name")
    private String responsibleUserName;

    /**
     * 负责人电话
     */
	@TableField("responsible_user_phone")
    private String responsibleUserPhone;

    /**
     * 整改照片
     */
	@TableField(value = "rectification_photo", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationPhoto;
}
