package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 基础并网验收表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_basic_grid_acceptance")
public class BasicGridAcceptance extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 施工单ID
     */
    @TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站ID
     */
    @TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户ID
     */
    @TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 并网状态
     */
    @TableField("grid_status")
    private String gridStatus;

    /**
     * 验收状态
     */
    @TableField("acceptance_status")
    private String acceptanceStatus;

    /**
     * 验收时间
     */
    @TableField("acceptance_rec_date")
    protected Date acceptanceRecDate;

    /**
     * 工作流实例ID
     */
    @TableField("instance_id")
    private String instanceId;

    ///	下一个节点角色权限
    @TableField("next_executor_ids")
    private String nextExecutorIds;

    //	当前节点执行任务id
    @TableField("promoter")
    private String promoter;

    //	流程下一节点id
    @TableField("next_task_id")
    private String nextTaskId;
    //下一节点可执行人逗号分割	0	0
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;
    //工作流发起人id
    @TableField("create_user_id")
    private String createUserId;
    //下个节点名称
    @TableField("next_node_name")
    private String nextNodeName;
    //下个节点key
    @TableField("next_node_key")
    private String nextNodeKey;

}
