package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 审核单
 *
 * @author system_generator
 * @date 2024-08-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value="hygf_rectification_order",autoResultMap = true)
@ApiModel(value = "HygfRectificationOrder",description ="审核单")
public class HygfRectificationOrder extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 农户姓名
     */
    @ApiModelProperty(value = "农户姓名",example = "冯宗荣")
	@TableField("peasant_househole_name")
    private String peasantHouseholeName;

    /**
     * 农户编号
     */
    @ApiModelProperty(value = "农户编号",example = "NH085SXAKZY202406274366")
	@TableField("peasant_househole_code")
    private String peasantHouseholeCode;

    /**
     * 项目地址
     */
    @ApiModelProperty(value = "项目地址",example = "陕西省/安康市/紫阳县")
    @TableField("project_address_name")
    private String projectAddressName;
    /**
     * 农户场站id
     */
    @ApiModelProperty(value = "农户场站id",example = "1806275143140405250")
	@TableField("peasant_househole_id")
    private Long peasantHouseholeId;

    /**
     * 整改项
     */
    @ApiModelProperty(value = "整改项",example = "[{\"value\":\"巴登巴登棒棒哒\"},{\"value\":\"好多好多好多\"}]")
	@TableField(value = "rectification_idea", typeHandler = FastjsonTypeHandler.class)
    private List<Object>  rectificationIdea;

    /**
     * 整改附件
     */
    @ApiModelProperty(value = "整改附件",example = "[{\"uid\":\"0.q86dqhs5ox\",\"name\":\"测试11文档 - 副本 (2).pdf\",\"url\":\"/upload/common/2A1F49AD23EE80CE924174E57936235.pdf\"}]")
	@TableField(value = "rectification_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationFile;

    /**
     * 整改结果附件
     */
    @ApiModelProperty(value = "整改结果附件",example = "[{\"uid\":\"0.mh6ka3udyu\",\"name\":\"测试11文档 - 副本 (5).pdf\",\"url\":\"/upload/common/2E7114E14DD89C11BCAA9C3803AF16B.pdf\"}]")
	@TableField(value = "result_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> resultFile;

    /**
     * 整改结果
     */
    @ApiModelProperty(value = "整改结果",example = "[{\"value\":\"22\"}]")
	@TableField(value ="rectification_result", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationResult;

    /**
     * 审核意见
     */
    @ApiModelProperty(value = "审核意见",example = "片区审核驳回")
	@TableField("audit_idea")
    private String auditIdea;

    /**
     * 审核结果
     */
    @ApiModelProperty(value = "审核结果",example = "通过")
	@TableField("audit_result")
    private String auditResult;


    /**
     * 整改类型
     */
    @ApiModelProperty(value = "整改类型",example = "土建类")
    @TableField("rectification_type")
    private String rectificationType;


    /**
     * 整改来源
     */
    @ApiModelProperty(value = "整改来源",example = "area")
    @TableField("rectification_source")
    private String rectificationSource;
    
    /**
     * 整改来源
     */
    @ApiModelProperty(value = "整改来源",example = "area")
    @TableField(exist = false)
    private String rectificationSourceName;

    /**
     * 整改历史意见
     */
    @ApiModelProperty(value = "整改历史意见",example = "[{\"value\":\"片区不通过\"},{\"value\":\"2024-08-16 10:20:34: 片区驳回不通过\"}]")
    @TableField(value = "rectification_history", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationHistory;

    /**
     * 整改单状态
     */
    @ApiModelProperty(value = "整改单状态",example = "已完成")
    @TableField("rectification_status")
    private String rectificationStatus;


    /**
     * 是否提交 0 提交 1 暂存
     */
    @ApiModelProperty(value = "是否提交 0 提交 1 暂存",example = "0")
    @TableField(exist = false)
    private String addorSubmit;


    /**
     * 工程负责人
     */
    @ApiModelProperty(value = "工程负责人",example = "admin")
    @TableField("project_region_manger")
    private String projectRegionManager;


    /**
     * 是否提交 0 提交 1 暂存
     */
    @ApiModelProperty(value = "是否提交 0 提交 1 暂存",example = "0")
    @TableField(exist = false)
    private String isAudit;
    @ApiModelProperty(value = "结果WEB",example = "结果WEB")
    @TableField(exist = false)
    private String rectificationResultWeb;
    @ApiModelProperty(value = "历史WEB",example = "历史WEB")
    @TableField(exist = false)
    private String rectificationHistoryWeb;
    @ApiModelProperty(value = "ideaWeb",example = "ideaWeb")
    @TableField(exist = false)
    private String rectificationIdeaWeb;


}
