package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.Date;

/**
 * 人员任务
 *
 * @author system_generator
 * @date 2023-09-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_to_do_tasks")
public class ToDoTasks extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 任务类型
     */
    @TableField("type")
    private String type;

    /**
     * 业务id
     */
    @TableField("business_id")
    private Long businessId;

    /**
     * 任务状态
     */
    @TableField("state")
    private String state;

    /**
     * 用户id
     */
    @TableField("amos_user_id")
    private String amosUserId;

    /**
     *   任务创建时间
     */
    @TableField("creation_time")
    private Date creationTime;

    /**
     * 完成时间
     */
    @TableField("complete_time")
    private Date completeTime;

    /**
     * 任务名称
     */
    @TableField("task_name")
    private String taskName;

    /**
     *经销商orgCode
     */
    @TableField("amos_org_code")
    private String amosOrgCode;

    /**
     *路由地址
     */
    @TableField("route_path")
    private String routePath;

    /**
     *路由地址
     */
    @TableField("wx_route_path")
    private String wxRoutePath;


    public ToDoTasks(String type, Long businessId, String taskName, String orgCode) {
        addOperator();
        this.type = type;
        this.businessId = businessId;
        this.state = "待办";
        this.amosOrgCode = orgCode;
        this.creationTime = new Date();
        this.taskName = taskName;
    }

    public ToDoTasks(String type, Long businessId, String taskName, String orgCode, String routePath,String wxRoutePath) {
        addOperator();
        this.type = type;
        this.businessId = businessId;
        this.state = "待办";
        this.amosOrgCode = orgCode;
        this.creationTime = new Date();
        this.taskName = taskName;
        this.routePath = routePath;
        this.wxRoutePath= wxRoutePath;
    }

    public ToDoTasks(String type, Long businessId) {
        addOperator();
        this.type = type;
        this.businessId = businessId;
        this.state = "待办";
        this.creationTime = new Date();
    }

    public ToDoTasks() {
    }


    private void addOperator() {
        try {
            this.recDate = new Date();
            this.recUserId = RequestContext.getExeUserId();
            this.recUserName = RequestContext.getLoginId();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
