package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.dto.StationFieldDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfBusinessField;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.BusinessFieldServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "业务字段Api")
@RequestMapping(value = "/businessField")
public class BusinessFieldController {
    @Autowired
    BusinessFieldServiceImpl businessFieldService;


    /**
     * 获取所有的字段
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getAllField")
    @ApiOperation(httpMethod = "GET",value = "获取所有的字段",  notes = "获取所有的字段")
    public ResponseModel<Map<String,List<HygfBusinessField>>> getAllField() {
        return ResponseHelper.buildResponse(businessFieldService.getAllField());
    }

    /**
     * 导出电站Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/exportStationExcelByField")
    @ApiOperation(httpMethod = "POST", value = "导出电站Excel根据字段", notes = "导出电站Excel根据字段")
    public void exportStationExcelByField(@RequestBody StationFieldDto stationFieldDto, HttpServletResponse response) {
        businessFieldService.exportStationExcelByField(stationFieldDto, response);
    }

}
