package com.yeejoin.amos.boot.module.hygf.biz.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.hygf.api.dto.DataDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDtoNew;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpCollectorServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInverterElectricityServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInverterServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpStationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.parseArray;

/**
 * 户用光伏监盘逆变器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘逆变器表Api")
@RequestMapping(value = "/jp-inverter")
public class JpInverterController extends BaseController {

    @Autowired
    JpInverterServiceImpl jpInverterServiceImpl;
    @Autowired
    JpStationServiceImpl jpStationServiceImpl;
    @Autowired
    JpCollectorServiceImpl jpCollectorService;
    @Autowired
    JpInverterElectricityServiceImpl jpInverterElectricityService;

    @Autowired
    JpPersonStationMapper pPersonStationMapper;
    @Value("classpath:/json/paramsTree.json")
    private Resource paramsTree;


    /**
     * 新增户用光伏监盘逆变器表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器表", notes = "新增户用光伏监盘逆变器表")
    public ResponseModel<JpInverterDto> save(@RequestBody JpInverterDto model) {
        model = jpInverterServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器表", notes = "根据sequenceNbr更新户用光伏监盘逆变器表")
    public ResponseModel<JpInverterDto> updateBySequenceNbrJpInverter(@RequestBody JpInverterDto model,
                                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jpInverterServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器表", notes = "根据sequenceNbr删除户用光伏监盘逆变器表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jpInverterServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器表")
    public ResponseModel<JpInverterDto> selectOne(@PathVariable Long sequenceNbr) {
        JpInverterDto jpInverter=  jpInverterServiceImpl.queryBySeq(sequenceNbr);
        jpInverter.setDayPowerGeneration(jpInverter.getDayPowerGeneration()!=null?jpInverter.getDayPowerGeneration()/1000:0);
        jpInverter.setMonthPowerGeneration(jpInverter.getMonthPowerGeneration()!=null?jpInverter.getMonthPowerGeneration()/1000:0);
        jpInverter.setYearPowerGeneration(jpInverter.getYearPowerGeneration()!=null?jpInverter.getYearPowerGeneration()/1000:0);
        jpInverter.setTotalPowerGeneration(jpInverter.getTotalPowerGeneration()!=null?jpInverter.getTotalPowerGeneration()/1000:0);
        return ResponseHelper.buildResponse(jpInverter);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器表分页查询", notes = "户用光伏监盘逆变器表分页查询")
    public ResponseModel<Page<JpInverterDto>> queryForPage(@RequestParam(value = "current") int current,
                                                           @RequestParam(value = "size") int size, JpInverterDto jpInverterDto) {

        List<JpPersonStation> pPersonStation =null;
        if(jpInverterDto.getName()!=null&&!"".equals(jpInverterDto.getName())){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,jpInverterDto.getName());
            pPersonStation=pPersonStationMapper.selectList(qug1);

        }else{
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
             pPersonStation = pPersonStationMapper.selectList(qug);
        }

        if (!pPersonStation.isEmpty()) {
            Page<JpInverterDto> page = new Page<JpInverterDto>();
            page.setCurrent(current);
            page.setSize(size);
            List<String> ids = pPersonStation.stream().map(i -> i.getStationId()).collect(Collectors.toList());
            jpInverterDto.setStationIds(ids);
            return ResponseHelper.buildResponse(jpInverterServiceImpl.queryForJpInverterPage(page, jpInverterDto));
        } else {
            return ResponseHelper.buildResponse(new Page<JpInverterDto>());
        }
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器表列表全部数据查询", notes = "户用光伏监盘逆变器表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<JpInverterDto>> selectForList() {
        return ResponseHelper.buildResponse(jpInverterServiceImpl.queryForJpInverterList());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryForDataPage")
    @ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器表分页查询", notes = "户用光伏监盘采集器表分页查询")
    public ResponseModel<Page<JpInverterDtoNew>> queryForDataPage(@RequestParam(value = "current") int current,
                                                                  @RequestParam(value = "size") int size, JpInverterDto jpInverterDto) {
        Page<JpInverterDtoNew> page = new Page<JpInverterDtoNew>();
        page.setCurrent(current);
        page.setSize(size);
        if (StringUtils.isNotEmpty(jpInverterDto.getSnCode())){
            jpInverterDto.setSnCode("%"+jpInverterDto.getSnCode()+"%");
        }

        page.setTotal(jpInverterServiceImpl.selectPageDataTota(jpInverterDto));
        page.setRecords(jpInverterServiceImpl.selectPageData(jpInverterDto, (current - 1) * size, size));
        return ResponseHelper.buildResponse(page);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/selectParamTree")
    @ApiOperation(httpMethod = "GET", value = "逆变器图标 选择参数树", notes = "逆变器图标 选择参数树")
    public ResponseModel<List<Map>> selectParamTree() {

        String json = null;
        try {
            json = IOUtils.toString(paramsTree.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<Map> list = parseArray(json, Map.class);
        return ResponseHelper.buildResponse(list);
    }

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "/jpInverterTrend")
	@ApiOperation(httpMethod = "POST", value = "逆变器图标 折线图", notes = "逆变器图标 折线图")
	public  ResponseModel<Map<String,Object>>   jpInverterTrend (@RequestBody Map<String,Object> treeParams) {
		String time = treeParams.get("time").toString();
		String snCode = treeParams.get("snCode").toString();
		String thirdStationId = treeParams.get("thirdStationId").toString();
		if (treeParams.get("date").equals("day")){
			time = time+ " 00:00:00";
            String time2 = treeParams.get("time").toString()+ " 23:59:59";
//            Date date = null;
//            Date date2 = null;
//            try {
//                date = DateUtils.dateParse(time, null);
//                date2 = DateUtils.dateParse(time2, null);
////                Date date1 = DateUtils.dateAddHours(date, -8);
//                time = DateUtils.dateTimeToDateStringIfTimeEndZero(date);
//                time2 = DateUtils.dateTimeToDateStringIfTimeEndZero(date2);
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
            List<JSONObject> treeParams1 = parseArray(JSONObject.toJSONString(treeParams.get("treeParams")), JSONObject.class);
            if (CollectionUtils.isEmpty(treeParams1)){
                Map<String,Object> obj = new HashMap<>();
                return ResponseHelper.buildResponse(obj);
            }
            return   ResponseHelper.buildResponse(jpInverterServiceImpl.selectDayTrend(treeParams1, time,time2, snCode, thirdStationId));
        }else if (treeParams.get("date").equals("month")){
            return ResponseHelper.buildResponse(jpInverterServiceImpl.selectMonthTrend(time, snCode, thirdStationId));
        }else if (treeParams.get("date").equals("year")) {
            return ResponseHelper.buildResponse(jpInverterServiceImpl.selectYearTrend(time, snCode, thirdStationId));
        }else {
            return ResponseHelper.buildResponse(jpInverterServiceImpl.selectTotalTrend(time, snCode, thirdStationId));
        }
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getInverterSncodes")
    @ApiOperation(httpMethod = "GET", value = "获取逆变器snCode", notes = "获取逆变器snCode")
    public ResponseModel<List<Map<String,String>>> getInverterSncodes() {
        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        return ResponseHelper.buildResponse(jpInverterServiceImpl.getInverterSncodes(stationIds));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/jpInverterDayReport")
    @ApiOperation(httpMethod = "POST", value = "逆变器日报表", notes = "逆变器日报表")
    public ResponseModel<Page<TdHYGFInverterDayGenerate>> jpInverterDayReport(@RequestParam(value = "current") int current,
                                                                              @RequestParam(value = "size") int size,
                                                                              @RequestBody(required = false) DataDto dataDto) {
//		List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
       if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy-MM-dd"));
        }

//        List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;

        return ResponseHelper.buildResponse(jpInverterServiceImpl.jpInverterDayReport(current,size,dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(), dataDto.getName()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/jpInverterDayReportExport", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "GET", value = "逆变器日报表导出", notes = "逆变器日报表导出")
    public void jpInverterDayReportExport( @RequestBody(required = false) DataDto dataDto, HttpServletResponse response) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy-MM-dd"));
        }
        //List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;
        List<TdHYGFInverterDayGenerate> tdHYGFInverterDayGenerates =jpInverterServiceImpl.jpInverterDayReportExport(dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(), dataDto.getName());
        try {
            setResponseHeadForDowload(response,"逆变器日报表.xls");
            EasyExcel.write(response.getOutputStream()).head(TdHYGFInverterDayGenerate.class).excelType(ExcelTypeEnum.XLS).sheet("逆变器日报表").doWrite(tdHYGFInverterDayGenerates);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/jpInverterMonthReport")
    @ApiOperation(httpMethod = "GET", value = "逆变器月报表", notes = "逆变器月报表")
    public ResponseModel<Page<TdHYGFInverterMonthGenerate>> jpInverterMonthReport(@RequestParam(value = "current") int current,
                                                                                  @RequestParam(value = "size") int size,
                                                                                  @RequestBody(required = false) DataDto dataDto) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy-MM"));
        }
//        List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;

        return ResponseHelper.buildResponse(jpInverterServiceImpl.jpInverterMonthReport(current,size,dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(), dataDto.getName()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/jpInverterMonthReportExport", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "GET", value = "逆变器月报表导出", notes = "逆变器月报表导出")
    public void jpInverterMonthReportExport( @RequestBody(required = false) DataDto dataDto, HttpServletResponse response) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy-MM"));
        }
      //  List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;
        List<TdHYGFInverterMonthGenerate> tdHYGFInverterMonthGenerates =jpInverterServiceImpl.jpInverterMonthReportExport(dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(),dataDto.getName());
        try {
            setResponseHeadForDowload(response,"逆变器月报表.xls");
            EasyExcel.write(response.getOutputStream()).head(TdHYGFInverterMonthGenerate.class).excelType(ExcelTypeEnum.XLS).sheet("逆变器月报表").doWrite(tdHYGFInverterMonthGenerates);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/jpInverterYearReport")
    @ApiOperation(httpMethod = "GET", value = "逆变器年报表", notes = "逆变器年报表")
    public ResponseModel<Page<TdHYGFInverterYearGenerate>> jpInverterYearReport(@RequestParam(value = "current") int current,
                                                                                @RequestParam(value = "size") int size,
                                                                                @RequestBody(required = false) DataDto dataDto) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy"));
        }
       // List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;

        return ResponseHelper.buildResponse(jpInverterServiceImpl.jpInverterYearReport(current,size,dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(), dataDto.getName()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/jpInverterYearReportExport", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "GET", value = "逆变器年报表导出", notes = "逆变器年报表导出")
    public void jpInverterYearReportExport(@RequestBody(required = false) DataDto dataDto, HttpServletResponse response) {
//        List<JpStation> jpStation=jpStationServiceImpl.getJpStation(new JpStationDto());
//        List<String> stationIds = jpStation.stream().map(jpStation1 -> jpStation1.getThirdStationId()).collect(Collectors.toList());
        if(StringUtils.isEmpty(dataDto.getTime())){
            dataDto.setTime(DateUtil.format(new Date(),"yyyy"));
        }
       // List<String>   dd= snCodes!=null? JSON.parseArray(snCodes,String.class):null;
        List<TdHYGFInverterYearGenerate> tdHYGFInverterYearGenerates =jpInverterServiceImpl.jpInverterYearReportExport(dataDto.getTime(),dataDto.getSnCodes(),null,dataDto.getRegionalCompaniesCode(), dataDto.getName());
        try {
            setResponseHeadForDowload(response,"逆变器年报表.xls");
            EasyExcel.write(response.getOutputStream()).head(TdHYGFInverterYearGenerate.class).excelType(ExcelTypeEnum.XLS).sheet("逆变器年报表").doWrite(tdHYGFInverterYearGenerates);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 设置响应头
     *
     * @param response        响应体
     * @param dowloadFileName 下载文件名称
     */
    public void setResponseHeadForDowload(HttpServletResponse response, String dowloadFileName) {

        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(dowloadFileName, "UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/jpInverterTotal")
    @ApiOperation(httpMethod = "GET", value = "逆变器详折线图上方统计", notes = "逆变器详折线图上方统计")
    public ResponseModel<Map<String,Object>> jpInverterTotal( String time,String snCode,String thirdStationId,String date) {

        return ResponseHelper.buildResponse(jpInverterServiceImpl.jpInverterTotal(snCode,thirdStationId,time,date));
    }




    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/snCode/{snCode}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器表")
    public ResponseModel<JpInverterDto> selectOneBySnCode(@PathVariable String snCode) {
        LambdaQueryWrapper<JpInverter> query = new LambdaQueryWrapper<>();
        query.eq(JpInverter::getSnCode,snCode);
        query.orderByDesc(JpInverter::getUpdateTime);
        JpInverter jpInverter = jpInverterServiceImpl.getBaseMapper().selectList(query).get(0);

        jpInverter.setDayPowerGeneration(jpInverter.getDayPowerGeneration()!=null?Double.valueOf(String.format("%.3f",jpInverter.getDayPowerGeneration())):0);
        jpInverter.setMonthPowerGeneration(jpInverter.getMonthPowerGeneration()!=null?Double.valueOf(String.format("%.3f",jpInverter.getMonthPowerGeneration())):0);
        jpInverter.setYearPowerGeneration(jpInverter.getYearPowerGeneration()!=null?Double.valueOf(String.format("%.3f",jpInverter.getYearPowerGeneration())):0);
        jpInverter.setTotalPowerGeneration(jpInverter.getTotalPowerGeneration()!=null? Double.valueOf(String.format("%.3f",jpInverter.getTotalPowerGeneration()/1000)) :0);

        JpInverterDto jpInverterDto = new JpInverterDto();

        LambdaQueryWrapper<JpCollector> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JpCollector::getSnCode,jpInverter.getCollectorSnCode());
        wrapper.eq(BaseEntity::getIsDelete, false);
        List<JpCollector> jpCollector = jpCollectorService.getBaseMapper().selectList(wrapper);


        String[] names = new String[]{"PV1","PV2","PV3","PV4"};
        List<String> list = Arrays.asList(names);

        LambdaQueryWrapper<JpInverterElectricity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JpInverterElectricity::getSnCode,snCode);
        queryWrapper.eq(JpInverterElectricity::getThirdStationId,jpInverter.getThirdStationId());
        queryWrapper.and(q->q.eq(JpInverterElectricity::getType,"交流").or().in(JpInverterElectricity::getName,list));
        queryWrapper.orderByDesc(BaseEntity::getSequenceNbr);
        queryWrapper.last("limit 7");
        List<JpInverterElectricity> jpInverterElectricities = jpInverterElectricityService.getBaseMapper().selectList(queryWrapper);

        Map<String, List<JpInverterElectricity>> collect = jpInverterElectricities.stream().collect(Collectors.groupingBy(JpInverterElectricity::getType));

        jpInverterDto.setZL(collect.get("直流"));
        jpInverterDto.setJL(collect.get("交流"));
        jpInverterDto.setSnName(jpInverter.getSnName());
        jpInverterDto.setDirectCurrent(collect.get("直流"));
        jpInverterDto.setInterflow(collect.get("交流"));


        BeanUtils.copyProperties(jpInverter,jpInverterDto);
        jpInverterDto.setJpCollectors(jpCollector);

        return ResponseHelper.buildResponse(jpInverterDto);
    }

}
