package com.yeejoin.amos.boot.module.jxiop.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.api.dto.EXPersonUser;
import com.yeejoin.amos.boot.module.jxiop.api.dto.UserMapperDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.PersonBasic;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationQrCodeStatistics;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员基本信息 Mapper 接口
 *
 * @author system_generator
 * @date 2023-04-20
 */
public interface PersonBasicMapper extends BaseMapper<PersonBasic> {


    List<UserMapperDto> queryPage(@Param("current") Long current, @Param("size") Long size,
                                  @Param("name") String name,
                                  @Param("accountName") String accountName,
                                  @Param("projectName") String projectName,
                                  @Param("orgCode") String orgCode);

    List<UserMapperDto> queryPagecount(
            @Param("name") String name,
            @Param("accountName") String accountName,
            @Param("projectName") String projectName,
            @Param("orgCode") String orgCode);

    int deleteList(String[] ids);

    List<EXPersonUser> getEXPersonUser(@Param("name") String name,
                                       @Param("accountName") String accountName,
                                       @Param("projectName") String projectName,
                                       @Param("orgCode") String orgCode);


    List<EXPersonUser> getEXPersonUserAll(@Param("name") String name,
                                          @Param("accountName") String accountName,
                                          @Param("projectName") String projectName,
                                          @Param("orgCode") String orgCode,
                                          @Param("ids") String[] ids
    );

    List<Map<String, Object>> getPersonYardStatistics(@Param("parentCode") String parentCode,
                                                      @Param("areaCode") String areaCode,
                                                      @Param("platformStationId") String platformStationId);


    List<Map<String, Object>> getPersonYardByPage(@Param("current") Integer current,
                                                  @Param("size") Integer size,
                                                  @Param("parentCode") String parentCode,
                                                  @Param("date") String date,
                                                  @Param("qrCodeColor") String qrCodeColor,
                                                  @Param("ne") String ne,
                                                  @Param("areaCode") String areaCode,
                                                  @Param("platformStationId") String platformStationId);

    Integer getPersonYardByPageCount(@Param("parentCode") String parentCode,
                                     @Param("date") String date,
                                     @Param("qrCodeColor") String qrCodeColor,
                                     @Param("ne") String ne,
                                     @Param("areaCode") String areaCode,
                                     @Param("platformStationId") String platformStationId);

    List<StationQrCodeStatistics> getPersonStatistics();

    Map<String, Object> getPersonDetailInfoByObjectId(String objectId);

    List<Map<String, Object>> selectJobNumIsExist(String jobNum);
}
