package com.yeejoin.amos.api.openapi.enums;

/**
 * 
 * <pre>
 * 电梯关门到位枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftDoorStatusEnum.java, v 0.1 2021年9月29日 上午9:39:52 gwb Exp $
 */
public enum LiftDoorStatusEnum{

	NOT_CLOSED (0,"无关门到位信号"),
	CLOSE (1,"关门到位");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftDoorStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftDoorStatusEnum getEnum(Integer code)
	{
		for (LiftDoorStatusEnum liftDoorStatusEnum : LiftDoorStatusEnum.values())
		{
			if (liftDoorStatusEnum.getCode().equals(code))
			{
				return liftDoorStatusEnum;
			}
		}
		return null;
	}
}
