package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 游乐设施
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialRecreationFacilityModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 游乐设施线速度(m/s)
     */
    private String recreationFacilityLinearVelocity;
    /**
     * 游乐设施高度(m)
     */
    private String recreationFacilityHeight;
    /**
     * 额定乘客人数(人)
     */
    private String ratePassengerNum;
    /**
     * 额定载荷(kg)
     */
    private String ratedLoad;
    /**
     * 额定速度(m/s)
     */
    private String ratedSpeed;
    /**
     * 倾夹角或坡度(°)
     */
    private String inclinationSlope;
    /**
     * 副速度(m/s)
     */
    private String secSpeed;
    /**
     * 驱动形式
     */
    private String driveModel;
    /**
     * 驱动主功率(kW)
     */
    private String driveMainPower;
    /**
     * 电压(V)
     */
    private String voltage;
    /**
     * 副功率(kW)
     */
    private String secPower;
    /**
     * 座舱高度(m)
     */
    private String cockpitHeight;
    /**
     * 回转直径(mm)
     */
    private String rotaryDiameter;
    /**
     * 轨矩(m)
     */
    private String railMoment;
    /**
     * 轨矩长度(mm)
     */
    private String railMomentLength;
    /**
     * 水滑梯高度(m)
     */
    private String waterSlideHeigth;
    /**
     * 游乐池水深(m)
     */
    private String recreationPoolDepth;
    /**
     * 设计使用寿命
     */
    private String designUseLife;
    /**
     * 高度（静态）(m)
     */
    private String staticHeigth;

}
