package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * 气瓶基本信息
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_cylinder_info")
public class CylinderInfo  extends AbstractBaseEntity{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@TableField("cylinder_id")
	private String cylinderId;	//气瓶基本信息ID
	@TableField("unit_name")
	private String unitName;	//产权单位名称
	@TableField("factory_num")
	private String factoryNum;	//出厂编号
	@TableField("cylinder_status")
	private int cylinderStatus;	//气瓶状态
	@TableField("cylinder_variety")
	private int cylinderVariety;	//气瓶品种
	@TableField("qrCode")
	private String qrCode;	//二维码编号
	@TableField("electronic_label_code")
	private String electronicLabelCode;	//电子标签编号
	@TableField("filling_medium")
	private String fillingMedium;	//充装介质
	@TableField("pressure")
	private double pressure;	//公称压力(MPa）
	@TableField("volume")
	private double volume;	//容积（L）
	@TableField("manufacturing_date")
	private String manufacturingDate;	//制造日期
	@TableField("manufacturing_unit")
	private String manufacturingUnit;	//制造单位
	@TableField("license")
	private String license;	//气瓶制造许可证
	@TableField("cylinder_weight")
	private double cylinderWeight;	//气瓶重量（kg）
	@TableField("unit_inner_code")
	private String unitInnerCode;	//单位内部编号
	@TableField("inspection_date")
	private String inspectionDate;	//最近一次检验日期
	@TableField("next_inspection_date")
	private String nextInspectionDate;	//下次检验日期
	@TableField("sequence_code")
	private String sequenceCode;	//气瓶唯一标识码
	
}
