package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 区域
 *
 * @author duanwei
 * @date 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_area")
@ApiModel(value = "Area对象", description = "区域")
public class Area extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "区域名称")
    private String name;

    @ApiModelProperty(value = "区域编码")
    private String code;

    @ApiModelProperty(value = "区域类型")
    private String type;

    @ApiModelProperty(value = "父id")
    private Long parentId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "风险区域父节点id")
    @TableField(updateStrategy= FieldStrategy.IGNORED)
    private Long riskPointId;

    @ApiModelProperty(value = "是否删除:0-否；1-是")
    private Boolean isDelete;

    @ApiModelProperty(value = "单位编码")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String orgCode;

    @ApiModelProperty(value = "创建人id")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;

    @ApiModelProperty("机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty("机构编码")
    private String bizOrgCode;

}
