package com.yeejoin.equipmanage.common.enums;

/**
 * @Author: xl
 * @Description: NB监测设备枚举
 * @Date: 2021/10/13 11:17
 */
public enum NBalarmEnum {
    // 液位状态
    NB_liquid_level_state_0("NB_liquid_level_state_0", "正常"),
    NB_liquid_level_state_1("NB_liquid_level_state_1", "高液报警"),
    NB_liquid_level_state_2("NB_liquid_level_state_2", "低液报警"),
    NB_liquid_level_state_3("NB_liquid_level_state_3", "波动报警"),

    // 故障
    NB_error_code_0("NB_error_code_0", "正常"),
    NB_error_code_1("NB_error_code_1", "传感器故障"),
    NB_error_code_2("NB_error_code_2", "电池故障"),

    // 电池状态
    NB_battery_state_0("NB_battery_state_0", "正常"),
    NB_battery_state_1("NB_battery_state_1", "低电量"),

    // 水压状态
    NB_hydraulic_state_0("NB_hydraulic_state_0", "水压过高报警解除"),
    NB_hydraulic_state_1("NB_hydraulic_state_1", "水压过高报警"),
    NB_hydraulic_state_2("NB_hydraulic_state_2", "水压过低报警解除"),
    NB_hydraulic_state_3("NB_hydraulic_state_3", "水压过低报警"),
    NB_hydraulic_state_4("NB_hydraulic_state_4", "水压波动报警解除"),
    NB_hydraulic_state_5("NB_hydraulic_state_5", "水压波动报警"),

    // JS-报警状态
    NB_alarm_status_0("NB_alarm_status_0", "剩余电流报警"),
    NB_alarm_status_1("NB_alarm_status_1", "电流报警"),
    NB_alarm_status_2("NB_alarm_status_2", "电压报警"),
    NB_alarm_status_3("NB_alarm_status_3", "温度报警"),
    NB_alarm_status_4("NB_alarm_status_4", "报警恢复");

    String key;
    String desc;

    private NBalarmEnum(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }
    public String getKey() {
        return key;
    }
    public String getDesc() {
        return desc;
    }

    public static String getDescByKey(String key){
        for (NBalarmEnum constants : values()) {
            if (constants.getKey().equals(key)) {
                return constants.getDesc();
            }
        }
        return null;
    }
}
