package com.yeejoin.equipmanage.common.vo;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equipmanage.common.entity.DynamicFormColumn;
import com.yeejoin.equipmanage.common.entity.DynamicFormInstance;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 动态表单树形分组表带字段
 *
 * @author duanwei
 * @date 2021-03-08
 */
@Data
public class DynamicFormGroupVo {

    private Long id;

    @ApiModelProperty(value = "分组名称")
    private String groupName;

    @ApiModelProperty(value = "分组编号")
    private String groupCode;

    @ApiModelProperty(value = "分组类型（点位图过滤用）")
    private String groupType;

    @ApiModelProperty(value = "父级id")
    private Long parentId;

    @ApiModelProperty(value = "更新者id")
    private Long creatorId;

    @ApiModelProperty(value = "是否必须：0-否；1-是；控制前端tab是否可勾选掉")
    private Boolean isMust;

    @ApiModelProperty(value = "分组配置")
    private JSONObject groupConfig;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;

    private Boolean isDelete;

    private Date createDate;

    private List<DynamicFormGroupVo> children;

    private List<DynamicFormInstance> formInstances;
}
