package com.yeejoin.amos.knowledgebase.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;

/**
 * <p>
 * 知识库文档注释信息
 * </p>
 *
 * @author ningtianqing
 * @since 2020-09-16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeDocAnnotateModel extends BaseModel {

    /**
     * 文档id
     */
    private Long docSeq;
    /**
     * 添加注释的用户id
     */
    private String userId;
    /**
     * 添加注释的用户名称
     */
    private String username;

    /**
     * 是否是当前用户添加的注释
     */
    private Boolean isCurrentUser;
    /**
     * 添加注释后文档内容
     */
    private String htmlContent;
    /**
     * 注释内容
     */
    private String annotateContent;
    /**
     * 注释位置信息（前端定义和使用的内容）
     */
    private String positionInfo;
    /**
     * 机构编号
     */
    private String agencyCode;

    private Date createTime;

    private Date updateTime;

    public Date getUpdateTime() {
        return recDate;
    }
}

