package com.yeejoin.precontrol.common.enums;

/*
 * sqy
 * 劳动合同类型
 */
public enum ContractTypeEum {
    /*
     * 合同制
     */
    合同制("合同制", "0"),
    /*
     * 劳务派遣
     */
    劳务派遣("劳务派遣", "1"),
    /**
     * 临时协议
     */
    临时协议("临时协议", "2"),
    /**
     * 其他
     */
    其他("其他", "3");

    private String label;
    private String value;

    ContractTypeEum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getLabelByValue(String value) {
        String label = null;
        for (ContractTypeEum type : ContractTypeEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
