package com.yeejoin.precontrol.common.listener.hk;

import com.yeejoin.precontrol.common.enums.media.ResultMsg;
import com.yeejoin.precontrol.common.event.RegionAddEvent;
import com.yeejoin.precontrol.common.service.hk.HkPlatFormService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

@Slf4j
@Component
public class EventListener {
    @Autowired
    private HkPlatFormService hkPlatFormService;

    /**
     * 新增项目同步海康平台区域
     * @param event
     * @date 2021年5月7日18:14:25
     * @author songLei
     */
    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT)
    public void regionAddEvent(RegionAddEvent event) {
        log.info("监听到新增区域事件" + event.getHkRequestDto());
        Object obj = hkPlatFormService.batchAddRegion(event.getHkRequestDto());
        if (obj == null && obj.equals(ResultMsg.CALL_API_FAIL.getMsg())) {
            throw new BadRequest("新增项目同步海康平台区域发生错误");
        }
    }
}
