package com.yeejoin.precontrol.common.mapper;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.TaskRiskControlTechDto;
import com.yeejoin.precontrol.common.entity.TaskRiskControlTech;
import com.yeejoin.precontrol.common.vo.TaskRiskControlTechVo;

/**
 * 风险管控任务表 Mapper 接口
 *
 * @author duanwei
 * @date 2021-11-01
 */
public interface TaskRiskControlTechMapper extends BaseMapper<TaskRiskControlTech> {
	/**
	 * 根据当前人员id查询当前所关联计划
	 *
	 * @param page
	 * @param personId
	 * @param taskRiskControlDto
	 * @return
	 */
	Page<TaskRiskControlTechVo> myListByPage(Page<TaskRiskControlTechVo> page, @Param("personId") Long personId,
			@Param("taskRiskControlTechVo") TaskRiskControlTechDto taskRiskControlTechDto);

	/**
	 * 根据当前人员id查询当前所关联计划
	 *
	 * @param page
	 * @param personId
	 * @param taskRiskControlDto
	 * @return
	 */
	Page<TaskRiskControlTechVo> constructListByPage(Page<TaskRiskControlTechVo> page,
			@Param("taskRiskControlTechVo") TaskRiskControlTechDto taskRiskControlTechDto);
	
	Integer myListCount(Long personId);

}
