package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.List;

public enum TaskIsOrderEnum {
		ISORDER("顺序巡检","1"),
		NOTORDER("任意巡检建","0");
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private String value;
	

	private TaskIsOrderEnum(String name, String value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(String value) {
		for (TaskIsOrderEnum c : TaskIsOrderEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getValue(String name) {
		for (TaskIsOrderEnum c : TaskIsOrderEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(int value) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(String name) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskDetailIsFinishEnum c: PlanTaskDetailIsFinishEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getValue() {
		return value;
	}


	public void setValue(String value) {
		this.value = value;
	}
}
