package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 气瓶检验信息
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderInspectionDto", description="气瓶检验信息")
public class CylinderInspectionDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验信息ID")
    private String inspectionId;

    @ApiModelProperty(value = "检验单位")
    private String inspectionUnit;

    @ApiModelProperty(value = "产权单位名称")
    private String propertyUnitName;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "检验日期")
    private String inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    private String nextInspectionDate;

    @ApiModelProperty(value = "检验结果")
    private String inspectionResult;

    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
