package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶企业信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Data
@Accessors(chain = true)
@TableName("tz_cylinder_unit")
public class CylinderUnit  {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    /**
     * 单位ID
     */
	@TableField("unit_id")
    private String unitId;

    /**
     * 所属区域
     */
	@TableField("region_code")
    private String regionCode;

    /**
     * 单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 企业类型
     */
	@TableField("unit_type")
    private Integer unitType;

    /**
     * 统一社会信用代码
     */
	@TableField("credit_code")
    private String creditCode;

    /**
     * 详细地址
     */
	@TableField("address")
    private String address;

    /**
     * 企业负责人
     */
	@TableField("unit_person")
    private String unitPerson;

    /**
     * 企业负责人手机
     */
	@TableField("person_mobile_phone")
    private String personMobilePhone;

    /**
     * 企业负责人固定电话
     */
	@TableField("person_telephone")
    private String personTelephone;

    /**
     * 企业邮编
     */
	@TableField("postal_code")
    private String postalCode;

    /**
     * 企业简称
     */
	@TableField("unit_abbreviation")
    private String unitAbbreviation;

    /**
     * 充装许可证号
     */
	@TableField("filling_license")
    private String fillingLicense;

    /**
     * 充装许可证有效期
     */
	@TableField("filling_permit_date")
    private Date fillingPermitDate;

    /**
     * 充装许可范围
     */
	@TableField("filling_perm_scope")
    private String fillingPermScope;

    /**
     * 检验许可证号
     */
	@TableField("inspection_license")
    private String inspectionLicense;

    /**
     * 检验范围
     */
	@TableField("inspection_scope")
    private String inspectionScope;

    /**
     * 检验许可证有效期
     */
	@TableField("effective_date")
    private Date effectiveDate;

    /**
     * 制造许可证号
     */
	@TableField("manufacturing_license")
    private String manufacturingLicense;

    /**
     * 制造许可证有效期
     */
	@TableField("manufacturing_date")
    private Date manufacturingDate;

    /**
     * 制造许可范围
     */
	@TableField("manufacturing_scope")
    private String manufacturingScope;

    /**
     * 制造单位代码
     */
	@TableField("manufacturing_unit_code")
    private String manufacturingUnitCode;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 1初次同步数据   2上层系统已同步数据   0已删除数据
     */
	@TableField("sync_state")
    private Boolean syncState;

    /**
     * 对接公司编码
     */
    @TableField("app_id")
    private String appId;

    /**
     * 经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
    @TableField("latitude")
    private String latitude;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;
}
