package com.yeejoin.amos.boot.module.common.biz.controller;

import com.yeejoin.amos.boot.module.common.api.entity.FailureRepairlog;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureRepairlogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureRepairlogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 流程日志
 *
 * @author system_generator
 * @date 2021-08-12
 */
@RestController
@Api(tags = "流程日志Api")
@RequestMapping(value = "/common/failure-repairlog")
public class FailureRepairlogController extends BaseController {

    @Autowired
    FailureRepairlogServiceImpl failureRepairlogServiceImpl;

    /**
     * 新增流程日志
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增流程日志", notes = "新增流程日志")
	public ResponseModel<FailureRepairlogDto> save(@RequestBody FailureRepairlogDto model) {
	    model = failureRepairlogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新流程日志", notes = "根据sequenceNbr更新流程日志")
	public ResponseModel<FailureRepairlogDto> updateBySequenceNbrFailureRepairlog(@RequestBody FailureRepairlogDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(failureRepairlogServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除流程日志", notes = "根据sequenceNbr删除流程日志")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(failureRepairlogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个流程日志",  notes = "根据sequenceNbr查询单个流程日志")
	public ResponseModel<FailureRepairlogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(failureRepairlogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "流程日志分页查询",  notes = "流程日志分页查询")
	public ResponseModel<Page<FailureRepairlogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FailureRepairlogDto> page = new Page<FailureRepairlogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(failureRepairlogServiceImpl.queryForFailureRepairlogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "流程日志列表全部数据查询",   notes = "流程日志列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FailureRepairlogDto>> selectForList() {
	    return ResponseHelper.buildResponse(failureRepairlogServiceImpl.queryForFailureRepairlogList());
	}

	/**
	 * 查询报修日志
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询报修日志",   notes = "查询报修日志")
	@GetMapping(value = "/list/{faultId}")
	public ResponseModel<List<FailureRepairlog>> findByFaultIdLog(@PathVariable Long faultId) {
		return ResponseHelper.buildResponse(failureRepairlogServiceImpl.findByfaultIdLog(faultId));
	}
}
