package com.yeejoin.equipmanage.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.utils.CommonPageInfoParam;
import com.yeejoin.equipmanage.common.utils.CommonPageParamUtil;
import com.yeejoin.equipmanage.common.utils.CommonPageable;
import com.yeejoin.equipmanage.common.utils.CommonRequest;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.AlarmDataVO;
import com.yeejoin.equipmanage.common.vo.AlarmEquipMockDataVO;
import com.yeejoin.equipmanage.common.vo.AlarmListDataVO;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author keyong
 * @title: EquipmentAlarmController
 * <pre>
 * @description: 设备告警
 * </pre>
 * @date 2020/12/22 13:54
 */
@RestController
@Api(tags = "设备告警Api")
@RequestMapping(value = "/equipment-alarm", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentAlarmController extends AbstractBaseController {

    @Autowired
    IEquipmentSpecificAlarmService iEquipmentSpecificAlarmService;


    /**
     * 列表列名
     *
     * @return
     */
    @RequestMapping(value = "/column/title", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表获取列名", produces = "application/json;charset=UTF-8", notes = "列表获取列名")
    public ResponseModel listColumnName(@RequestParam(value = "alarmType", required = false) String alarmType) {
        List<HashMap<String, Object>> list = iEquipmentSpecificAlarmService.getColumn(alarmType);
        return CommonResponseUtil.success(list);
    }

    /**
     * 设备告警信息导出
     *
     * @return
     */
    @RequestMapping(value = "/downList", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "告警信息导出", notes = "告警信息导出")
    public void downList(HttpServletResponse response, @RequestParam(value = "ids", required = false) List<Long> ids,
                         @RequestParam(value = "alarmType") String alarmType) {
        iEquipmentSpecificAlarmService.handleExport(response, ids, alarmType);
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
    public ResponseModel listPage(@RequestParam(value = "beginDate", required = false) String beginDate,
                                  @RequestParam(value = "endDate", required = false) String endDate,
                                  @RequestParam(value = "warehouseStructureName", required = false) String warehouseStructureName,
                                  @RequestParam(value = "equipCode", required = false) String equipCode,
                                  @RequestParam(value = "handleStatus", required = false) String handleStatus,
                                  @RequestParam(value = "system", required = false) String system,
                                  @RequestParam(value = "alarmType", required = false) String alarmType,
                                  @RequestParam(value = "type", required = false) String type,
                                  @RequestParam(value = "buildIds", required = false) List<String> buildIds,
                                  @RequestParam(value = "id", required = false) String id,
                                  @RequestParam(value = "cleanStatus", required = false) String cleanStatus,
                                  @RequestParam(value = "isRemoveShield", required = false) String isRemoveShield,
                                  CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request = new CommonRequest();
        request.setName("beginDate");
        request.setValue(StringUtil.isNotEmpty(beginDate) ? StringUtils.trimToNull(beginDate).substring(0, 10) + " 00:00:00" : null);
        queryRequests.add(request);
        CommonRequest request1 = new CommonRequest();
        request1.setName("endDate");
        request1.setValue(StringUtil.isNotEmpty(endDate) ? StringUtils.trimToNull(endDate).substring(0, 10) + " 23:59:59" : null);
        queryRequests.add(request1);
        CommonRequest request2 = new CommonRequest();
        request2.setName("warehouseStructureName");
        request2.setValue(StringUtil.isNotEmpty(warehouseStructureName) ? StringUtils.trimToNull(warehouseStructureName) : null);
        queryRequests.add(request2);
        CommonRequest request3 = new CommonRequest();
        request3.setName("equipCode");
        request3.setValue(StringUtil.isNotEmpty(equipCode) ? StringUtils.trimToNull(equipCode) : null);
        queryRequests.add(request3);
        CommonRequest request4 = new CommonRequest();
        request4.setName("alarmType");
        request4.setValue(StringUtil.isNotEmpty(alarmType) ? StringUtils.trimToNull(alarmType) : null);
        queryRequests.add(request4);
        CommonRequest request5 = new CommonRequest();
        request5.setName("orgCode");
        request5.setValue(this.getOrgCode());
        queryRequests.add(request5);
        CommonRequest request6 = new CommonRequest();
        request6.setName("handleStatus");
        request6.setValue(StringUtil.isNotEmpty(handleStatus) ? StringUtils.trimToNull(handleStatus) : null);
        queryRequests.add(request6);
        CommonRequest request7 = new CommonRequest();
        request7.setName("system");
        request7.setValue(StringUtil.isNotEmpty(system) ? StringUtils.trimToNull(system) : null);
        queryRequests.add(request7);
        CommonRequest request8 = new CommonRequest();
        request8.setName("type");
        request8.setValue(StringUtil.isNotEmpty(type) ? StringUtils.trimToNull(type) : null);
        queryRequests.add(request8);
        CommonRequest request9 = new CommonRequest();
        request9.setName("buildIds");
        request9.setValue(ObjectUtils.isEmpty(buildIds) ? null : buildIds);
        queryRequests.add(request9);
        CommonRequest request10 = new CommonRequest();
        request10.setName("id");
        request10.setValue(StringUtil.isNotEmpty(id) ? StringUtils.trimToNull(id) : null);
        queryRequests.add(request10);
        CommonRequest request11 = new CommonRequest();
        request11.setName("cleanStatus");
        request11.setValue(StringUtil.isNotEmpty(cleanStatus) ? StringUtils.trimToNull(cleanStatus) : null);
        queryRequests.add(request11);
        CommonRequest request12 = new CommonRequest();
        request12.setName("isRemoveShield");
        request12.setValue(StringUtil.isNotEmpty(isRemoveShield) ? StringUtils.trimToNull(isRemoveShield) : null);
        queryRequests.add(request12);
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<Map<String, Object>> list = iEquipmentSpecificAlarmService.listPage(param);
        return CommonResponseUtil.success(list);
    }

    /**
     * 通过id获取告警详情
     *
     * @return
     */
    @RequestMapping(value = "/detail/alarm", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取告警详情", produces = "application/json;charset=UTF-8", notes = "获取告警详情")
    public ResponseModel alarmDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "alarmType") String alarmType) {
        List<AlarmDataVO> list = iEquipmentSpecificAlarmService.getAlarmDetailById(id, alarmType);
        return CommonResponseUtil.success(list);
    }

    /**
     * 通过id获取设备详情
     *
     * @return
     */
    @RequestMapping(value = "/detail/equipment", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取设备详情", produces = "application/json;charset=UTF-8", notes = "获取设备详情")
    public ResponseModel equipmentDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "alarmType") String alarmType) {
        AlarmEquipMockDataVO alarmEquipMockDataVO = iEquipmentSpecificAlarmService.getEquipmentDetailById(id, alarmType);
        return CommonResponseUtil.success(alarmEquipMockDataVO);
    }

    /**
     * 详情
     *
     * @return
     */
    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取详情", produces = "application/json;charset=UTF-8", notes = "获取详情")
    public ResponseModel detail(@RequestParam(value = "id") Long id) {
        Map<String, Object> result = iEquipmentSpecificAlarmService.detail(id);
        return CommonResponseUtil.success(result);
    }

    /**
     * 数字换流站警情列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/lingZhou/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数字换流站列表分页查询", produces = "application/json;charset=UTF-8", notes = "数字换流站列表分页查询")
    public ResponseModel listAlarmsPage(@RequestParam(value = "beginDate", required = false) String beginDate,
                                        @RequestParam(value = "endDate", required = false) String endDate,
                                        @RequestParam(value = "warehouseStructureName", required = false) String warehouseStructureName,
                                        @RequestParam(value = "equipCode", required = false) String equipCode,
                                        @RequestParam(value = "confirmType", required = false) String confirmType,
                                        @RequestParam(value = "alarmType", required = false) String alarmType,
                                        @RequestParam(value = "systemCode", required = false) String systemCode,
                                        @RequestParam(value = "buildId", required = false) String buildId,
                                        @RequestParam(value = "isRemoveShield", required = false) String isRemoveShield,
                                        @RequestParam(value = "id", required = false) String id,
                                        @RequestParam(value = "cleanStatus", required = false) String cleanStatus,
                                        @RequestParam(value = "isRemovedFire", required = false) String isRemovedFire,
                                        CommonPageable commonPageable) {
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request = new CommonRequest();
        request.setName("beginDate");
        request.setValue(StringUtil.isNotEmpty(beginDate) ? StringUtils.trimToNull(beginDate).substring(0, 10) + " 00:00:00" : null);
        queryRequests.add(request);
        CommonRequest request1 = new CommonRequest();
        request1.setName("endDate");
        request1.setValue(StringUtil.isNotEmpty(endDate) ? StringUtils.trimToNull(endDate).substring(0, 10) + " 23:59:59" : null);
        queryRequests.add(request1);
        CommonRequest request2 = new CommonRequest();
        request2.setName("warehouseStructureName");
        request2.setValue(StringUtil.isNotEmpty(warehouseStructureName) ? StringUtils.trimToNull(warehouseStructureName) : null);
        queryRequests.add(request2);
        CommonRequest request3 = new CommonRequest();
        request3.setName("equipCode");
        request3.setValue(StringUtil.isNotEmpty(equipCode) ? StringUtils.trimToNull(equipCode) : null);
        queryRequests.add(request3);
        CommonRequest request6 = new CommonRequest();
        // confirmType: '' 为全部数据 0 为未确认 1为已确认
        request6.setName("confirmType");
        request6.setValue(StringUtil.isNotEmpty(confirmType) ? StringUtils.trimToNull(confirmType) : null);
        queryRequests.add(request6);
        CommonRequest request4 = new CommonRequest();
        request4.setName("alarmType");
        request4.setValue(StringUtil.isNotEmpty(alarmType) ? StringUtils.trimToNull(alarmType) : null);
        queryRequests.add(request4);
        CommonRequest request8 = new CommonRequest();
        request8.setName("systemCode");
        request8.setValue(StringUtil.isNotEmpty(systemCode) ? StringUtils.trimToNull(systemCode) : null);
        queryRequests.add(request8);
        CommonRequest request9 = new CommonRequest();
        request9.setName("buildId");
        request9.setValue(StringUtil.isNotEmpty(buildId) ? StringUtils.trimToNull(buildId) : null);
        queryRequests.add(request9);
        CommonRequest request10 = new CommonRequest();
        request10.setName("id");
        request10.setValue(StringUtil.isNotEmpty(id) ? StringUtils.trimToNull(id) : null);
        queryRequests.add(request10);
        CommonRequest request11 = new CommonRequest();
        request11.setName("cleanStatus");
        request11.setValue(StringUtil.isNotEmpty(cleanStatus) ? StringUtils.trimToNull(cleanStatus) : null);
        queryRequests.add(request11);
        CommonRequest request12 = new CommonRequest();
        request12.setName("isRemoveShield");
        request12.setValue(StringUtil.isNotEmpty(isRemoveShield) ? StringUtils.trimToNull(isRemoveShield) : null);
        queryRequests.add(request12);
        CommonRequest request13 = new CommonRequest();
        request13.setName("isRemovedFire");
        request13.setValue(StringUtil.isNotEmpty(isRemovedFire) ? StringUtils.trimToNull(isRemovedFire) : null);
        queryRequests.add(request13);
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        org.springframework.data.domain.Page<AlarmListDataVO> list = iEquipmentSpecificAlarmService.listAlarmsPage(param);
        return CommonResponseUtil.success(list);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数字换流站根据id获取装备详情", produces = "application/json;charset=UTF-8", notes = "数字换流站根据id获取装备详情")
    public ResponseModel getSpecificInfoById(@RequestParam(value = "id") Long id) {
        Map<String, Object> map = iEquipmentSpecificAlarmService.getSpecificInfoById(id);
        return CommonResponseUtil.success(map);
    }

    @RequestMapping(value = "/infoBySpecCode", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数字换流站根据code获取装备详情", produces = "application/json;charset=UTF-8", notes = "数字换流站根据id获取装备详情")
    public ResponseModel getSpecificInfoById(@RequestParam(value = "code") String code) {
        Map<String, Object> map = iEquipmentSpecificAlarmService.getSpecificInfoByCode(code);
        return CommonResponseUtil.success(map);
    }

}
