package com.yeejoin.equipmanage.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentStandard;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentStandardVO;
/**
 * 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IEquipmentStandardService extends IService<EquipmentStandard> {
	
	
	  /**
     * 列表分页查询
     *
     * @return
     */
	IPage<EquipmentStandardVO> findEquipmentStandardList( Page page, String orgCode,String StandardKey,String equipmentName);
	 /**
     * 获取本公司还没有添加维保规范的装备名称集合
     * @param request
     * @param companyCode
     * @return
     */
    List<Map<String, String>> getNoAddEquipmentStandardNameList(String orgCode);
    
    /**
     * 通过id查找对应的数据
     * @param id
     * @return
     */
    EquipmentStandardVO  findById(Long id);
}
