package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.SourceScene;
import com.yeejoin.equipmanage.mapper.SourceSceneMapper;
import com.yeejoin.equipmanage.service.ISourceSceneService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Optional;

/**
 * @author DELL
 */
@Service
public class SourceSceneServiceImpl extends ServiceImpl<SourceSceneMapper, SourceScene> implements ISourceSceneService {
    /**
     * @Description 根据sourceId查询
     * @param sourceId
     * @Return List<SourceScene>
     * @Date 2020/12/19 15:25
     */
    @Override
    public List<SourceScene> findBySourceId(Long sourceId){
        Optional.ofNullable(sourceId).orElseThrow(() -> new BadRequest("sourceId为空"));
        return this.list(new QueryWrapper<SourceScene>().lambda().eq(SourceScene::getSourceId,sourceId));
    }

    @Override
    public List<SourceScene> findByType(String type) {
        Optional.ofNullable(type).orElseThrow(() -> new BadRequest("type为空"));
        return this.list(new QueryWrapper<SourceScene>().lambda().eq(SourceScene::getSourceType,type));
    }
}
