package com.yeejoin.amos.maintenance.business.feign;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@FeignClient(name = "${jcs.fegin.name}",configuration = FeignConfiguration.class)
public interface JCSFeignClient {

    /**
     * 查询用户单位信息
     * @param userId 用户id
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "jcs/org-usr/{userId}/userUnit")
    FeignClientResult getUserUnit(@PathVariable String userId);


    /**
     * 根据主键查orgIds
     * @return
     */
    @RequestMapping(value = "jcs/common/maintenance-company/get/amosOrgIdsByIds", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<String>> getAmosOrgIdsByIds(@RequestParam(value = "list") List<String> list);
}
