package com.yeejoin.amos.maintenance.business.service.impl;

import com.yeejoin.amos.boot.biz.common.constants.RuleConstant;
import com.yeejoin.amos.boot.biz.common.enums.RuleTypeEnum;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.maintenance.business.dto.PlanRo;
import com.yeejoin.amos.maintenance.business.feign.JCSFeignClient;
import com.yeejoin.amos.maintenance.business.util.DateUtil;
import com.yeejoin.amos.maintenance.dao.entity.Plan;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RulePlanService {
    private final String packageId = "消息/addMaintenance";
    private final String msgType = "maintenance";

    @Autowired
    private RuleTrigger ruleTrigger;
    @Autowired
    private JCSFeignClient jcsFeignClient;

    public Boolean addPlanRule(Plan plan, List<String> userIds, RuleTypeEnum ruleType, List<String> extraUserIds) throws Exception {
        PlanRo planRo = buildPlanRo(plan, userIds, ruleType, extraUserIds);
        //触发规则
        ruleTrigger.publish(planRo, packageId, new String[0]);
        return true;
    }

    private PlanRo buildPlanRo(Plan plan, List<String> userIds, RuleTypeEnum ruleType, List<String> extraUserIds) {

        PlanRo planRo = new PlanRo();
        BeanUtils.copyProperties(plan, planRo);
        planRo.setMsgType(msgType);
        planRo.setRuleType(ruleType.getCode());
        planRo.setRelationId(String.valueOf(plan.getId()));
        planRo.setTerminal(ruleType.getTerminal());
        planRo.setCategory(ruleType.getCategory());
        Map<String, String> map = new HashMap<>();
        map.put("planId", String.valueOf(plan.getId()));

        if (!ValidationUtil.isEmpty(ruleType.getUrl())){
            map.put("url", ruleType.getUrl());
        }

        if (RuleConstant.WEB.equals(ruleType.getTerminal())){
            planRo.setIsSendWeb(true);
        } else if (RuleConstant.APP.equals(ruleType.getTerminal())){
            planRo.setIsSendApp(true);
        } else if (RuleConstant.APP_WEB.equals(ruleType.getTerminal())){
            planRo.setIsSendWeb(true);
            planRo.setIsSendApp(true);
        }

        planRo.setSendTime(DateUtil.date2LongStr(new Date()));
        planRo.setRecivers(extraUserIds);
        planRo.setExtras(map);
        return planRo;
    }
}
