package com.yeejoin.amos.patrol.jpush;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.common.enums.JPushTypeEnum;

import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;



@Service
public class AppMessagePushService {

	
	protected static final Logger log = LoggerFactory
			.getLogger(AppMessagePushService.class);

	
	    @Autowired
	    private  com.yeejoin.amos.patrol.feign.PushFeign PushFeign;
//	private static String APP_KEY;
//	    
//    private static String MASTER_SECRET;
//  
//    @Value("${params.jpush.appKey}")
//    public void setAppKey(String appKey) {
//        this.APP_KEY = appKey;
//    }
//    @Value("${params.jpush.masterSecret}")
//    public void setMasterSecret(String masterSecret) {
//        this.MASTER_SECRET = masterSecret;
//    }
	
	@Value("${params.isPush}")
	private String isPush;

	protected static final String APP_KEY = "1b3f7b961200f4b236811dfe";
	protected static final String MASTER_SECRET = "8b650e645fb3a43c96be02b2";
	//

	private static JPushClient jpushClient = new JPushClient(MASTER_SECRET,
			APP_KEY);
	 public static String buildJpushUserKey(String userId) {
	        return XJConstant.JPUSH_USER_KEY + "_" + userId;
	    }
	    
//	private static JPushClient jpushClient = null;
//
//	public static JPushClient getJPushClient(String APP_KEY, String MASTER_SECRET) {
//		if (jpushClient == null) {
//			return new JPushClient(MASTER_SECRET,
//					APP_KEY);
//		}
//		return jpushClient;
//	}


	/*public void sendMessage(List<PushMsgParam> responses)
	{
		PushFeign.sendMessage(responses);
		try
		{
			if(responses!=null && "true".equals(isPush))
			{
				for(PushMsgParam response:responses)
				{
					PushPayload payload = buildPushPayload(response);
					jpushClient.sendPush(payload);
				}
			}
		}
		catch (Exception e){
			log.error(e.getMessage(),e);
			e.printStackTrace();
		}
	}
*/
	private PushPayload buildPushPayload(PushMsgParam response) {
		CommonResponse  commonResponse = PushFeign.buildPushPayload(response);
    	return (PushPayload)commonResponse.getDataList();
		/*if(JPushTypeEnum.ALL.getCode().equals(response.getType())){
			return PushPayload.newBuilder()
					.setPlatform(Platform.android())
					.setAudience(Audience.all())
					.setNotification(Notification.android(response.getContent(), response.getSubject(),  response.getExtras()))
					.build();
		}else if(JPushTypeEnum.TAG.getCode().equals(response.getType())){
			return PushPayload.newBuilder().setPlatform(Platform.android())
					.setAudience(Audience.tag(response.getRecivers()))
					.setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
					.build();
		}else{
			return PushPayload.newBuilder().setPlatform(Platform.android())
					.setAudience(Audience.alias(response.getRecivers())).
					setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
					.build();
		}*/

	}

//	public void sendMessage(PushMsgParam response){
//		
//		try {
//			if(null!=response && "true".equals(isPush)){
//				CommonResponse  commonResponse = PushFeign.sendMessageone(response);
//			}
//		} catch (Exception e) {
//			log.error(e.getMessage(),e);
//			e.printStackTrace();
//		
//		}
//	}

}
