package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.EnterpriseLocusDto;
import com.yeejoin.precontrol.common.entity.PersonContract;
import com.yeejoin.precontrol.common.service.IPersonContractService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

/**
 * 人员合同信息
 *
 * @author duanwei
 * @date 2020-06-30
 */
@RestController
@Api(tags = "人员合同信息Api")
@RequestMapping(value = "/person-contract", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class PersonContractController {

	/**
	 * 人员合同服务
	 */
	@Autowired
	IPersonContractService iPersonContractService;

	/**
	 * 新增人员合同信息
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增人员合同信息", notes = "新增人员合同信息")
	public boolean savePersonContract(HttpServletRequest request, @RequestBody PersonContract personContract) {
		return iPersonContractService.save(personContract);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonContractService.removeById(id);
	}

	/**
	 * 修改人员合同信息
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改人员合同信息", notes = "修改人员合同信息")
	public boolean updateByIdPersonContract(HttpServletRequest request, @RequestBody PersonContract personContract) {
		return iPersonContractService.updateById(personContract);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Object selectById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonContractService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public Object listPage(String pageNum, String pageSize, PersonContract personContract) {

		Page<PersonContract> pageBean;
		QueryWrapper<PersonContract> personContractQueryWrapper = new QueryWrapper<>();
		Class<? extends PersonContract> aClass = personContract.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(personContract);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(personContract);
						personContractQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(personContract);
						personContractQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(personContract);
						personContractQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(personContract);
						personContractQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<PersonContract> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iPersonContractService.page(pageBean, personContractQueryWrapper);
		return page;
	}

	@GetMapping("/EnterpriseLocus")
	@ApiOperation(httpMethod = "GET", value = "人员企业轨迹", notes = "人员企业轨迹")
	public Object enterpriseLocusByPersonId(@ApiParam(value = "分页参数")CommonPageableDto pageableDto, EnterpriseLocusDto enterpriseLocusDto) {
		return iPersonContractService.enterpriseLocusByPersonId(enterpriseLocusDto,pageableDto);
	}
}
