package com.yeejoin.amos.supervision.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.business.param.InputItemPageParam;
import com.yeejoin.amos.supervision.business.service.intfc.IRoutePointItemService;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.CommonResponseUtil;
import com.yeejoin.amos.supervision.business.util.InputItemParamUtil;
import com.yeejoin.amos.supervision.business.vo.RoutePointItemVo;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;
import com.yeejoin.amos.supervision.dao.entity.Plan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;

/**
 * @author gaojianqiang
 * @date 2021/09/10 11:28
 */
@RestController
@RequestMapping(value = "/api/routePointItem")
@Api(tags = "巡检路线点项api")
public class RoutePointItemController extends AbstractBaseController {

    private final Logger log = LoggerFactory.getLogger(RoutePointItemController.class);

    @Autowired
    private IRoutePointItemService routePointItemService;

    /**
     * 增加巡检路线点项关系
     *
     * @param plan         巡检计划
     * @param inputItemIds 巡检项IDS
     * @return CommonResponse
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "新增巡检路线点项关系", notes = "新增巡检路线点项关系")
    @PostMapping(value = "/addRoutePointItem", produces = "application/json;charset=UTF-8")
    public CommonResponse addRoute(@ApiParam(value = "巡检计划", required = true) @RequestBody Plan plan,
                                   @ApiParam(value = "检查项IDS", required = false) @RequestParam List<Long> inputItemIds,
                                   @ApiParam(value = "是否保存并提交", required = true) @RequestParam Boolean status) {
        try {
            String userId = getUserId();
            if (StringUtils.isNotBlank(userId)) {
                return CommonResponseUtil.success(routePointItemService.addRoutePointItemList(plan, inputItemIds, status, userId));
            }
            return CommonResponseUtil.failure("创建用户为空！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("巡检路线点项关系新增失败！");
        }
    }

    /**
     * 分页查询检查项
     *
     * @param queryRequests
     * @param pageable
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询检查项", notes = "分页查询检查项")
    @RequestMapping(value = "/queryPage", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryPage(
            @ApiParam(value = "组合查询条件", required = false, defaultValue = "[]") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = false, defaultValue = "current=0&pageSize=10或pageNumber0&pageSize=10") CommonPageable pageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgCode", loginOrgCode);
        InputItemPageParam criterias = InputItemParamUtil.fillInputItemPageParam(queryRequests, pageable, paramMap);
        Page<RoutePointItemVo> page = routePointItemService.queryPage(criterias);
        return CommonResponseUtil.success(page);
    }

    /**
     * 删除巡检路线点项关系
     *
     * @return CommonResponse
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除巡检路线点项关系", notes = "删除巡检路线点项关系")
    @PostMapping(value = "/deleteByIdIn", produces = "application/json;charset=UTF-8")
    public CommonResponse deleteByIdIn(@ApiParam(value = "ids", required = true) @RequestParam List<String> itemIds, @RequestParam Long planId) {
        try {
            routePointItemService.deleteByIdIn(itemIds, planId);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检路线点项关系失败！");
        }
    }
}
