package com.yeejoin.amos.boot.module.tzs.biz.action;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.CylWarningMsgDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMessageDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.MsgLog;
import com.yeejoin.amos.boot.module.tzs.api.entity.WechatRelation;
import com.yeejoin.amos.boot.module.tzs.api.enums.EarlyWarningLevelEnum;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.MsgLogServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.WechatRelationServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.WechatServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.CylinderInfoServiceImpl;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;

@Component
@RuleActionBean(beanLabel = "气瓶预警消息")
public class CylWarningMsgAction{
    private final Logger logger = LoggerFactory.getLogger(CylWarningMsgAction.class);
    @Value("${tzs.wechat.tempId.warning}")
    private String templateId_Warning;
    @Autowired
    WechatRelationServiceImpl wechatRelationService;
    @Autowired
    WechatServiceImpl wechatServiceImpl;
    @Autowired
    CylinderInfoServiceImpl cylinderInfoServiceImpl;
    @Autowired
    MsgLogServiceImpl msgLogServiceImpl;
    @Autowired
    private EmqKeeper emqKeeper;

    @Value("${mqtt.topic.cyl.warning.push}")
    private String cylpushTopic;

//	@ExposeAction("气瓶预警消息")
    @RuleMethod(methodLabel = "气瓶预警消息方法", project = "气瓶监管")
	public void sendCylWebMessageTip(Object bizobj, String level,String orgUserName,String phone ,String text)
	{
		CylWarningMsgDto cylWarningMsgDto = (CylWarningMsgDto)bizobj;
		//更新气瓶等级
		logger.info("更新气瓶等级："+level);
		logger.info("预警区间："+cylWarningMsgDto.getNum());
		cylinderInfoServiceImpl.updateEarlyWarningLevel(cylWarningMsgDto.getCylSeq(), level);		
		//增加消息日志数据
		MsgLog msgLog = new MsgLog();
		msgLog.setRelationCode(cylWarningMsgDto.getCylSeq());
		msgLog.setMsgType(EarlyWarningLevelEnum.getEumByLevel(level).getCode());
		msgLog.setMsgTypeName(EarlyWarningLevelEnum.getEumByLevel(level).getName());
		msgLog.setBody(instedParams(text,cylWarningMsgDto));
		msgLog.setTargetCode(instedParams(phone,cylWarningMsgDto));
		msgLog.setTargetName(instedParams(orgUserName,cylWarningMsgDto));
		msgLog.setTerminalType("WEB");
		msgLog.setSendTime(new Date());
		msgLogServiceImpl.save(msgLog);
		logger.info("增加消息日志数据："+msgLog.toString());
		//发送web消息
        try {
            emqKeeper.getMqttClient().publish(cylpushTopic, instedParams(text,cylWarningMsgDto).getBytes("UTF-8"), 2, false);
            logger.info("气瓶预警消息发送成功：");
        } catch (MqttException e) {
        	e.printStackTrace();
            logger.error("mqtt发送失败" +text );
        } catch (UnsupportedEncodingException e) {
        	e.printStackTrace();
            logger.error("mqtt发送失败" +text );
        }
	}
    @RuleMethod(methodLabel = "气瓶公众号", project = "气瓶监管")
	public void sendCylWechatMessageTip(Object bizobj, String level,String orgUserName,String phone ,String text)
	{
		//增加消息日志数据
		CylWarningMsgDto cylWarningMsgDto = (CylWarningMsgDto)bizobj;
		MsgLog msgLog = new MsgLog();
		msgLog.setRelationCode(cylWarningMsgDto.getCylSeq());
		msgLog.setMsgType(EarlyWarningLevelEnum.getEumByLevel(level).getCode());
		msgLog.setMsgTypeName(EarlyWarningLevelEnum.getEumByLevel(level).getName());
		msgLog.setBody(instedParams(text,cylWarningMsgDto));
		msgLog.setTargetCode(instedParams(phone,cylWarningMsgDto));
		msgLog.setTargetName(instedParams(orgUserName,cylWarningMsgDto));
		msgLog.setTerminalType("APP");
		msgLog.setSendTime(new Date());
		msgLogServiceImpl.save(msgLog);
		//发送公众号消息
    	logger.info("气瓶预警消息发送开始："+phone);
		WechatRelation wechatRelation =wechatRelationService.getOne(new LambdaQueryWrapper<WechatRelation>().eq(WechatRelation::getPhone,phone));
		logger.info("气瓶预警消息发送OpenId："+wechatRelation.toString());
		if(null != wechatRelation) {
        	WechatMessageDto wechatMessageDto1 = new WechatMessageDto();
        	wechatMessageDto1.setTemplateId(templateId_Warning);
        	Map<String, String> data1 = Maps.newHashMap();
        	data1.put("first", "【陕西特种设备安全监察局】风险预警提醒");
        	data1.put("keyword1", instedParams(text,cylWarningMsgDto));
        	data1.put("keyword2", DateUtils.date2LongStr(new Date()));
        	wechatMessageDto1.setData(data1);
        	wechatServiceImpl.sendWechatModelMessage(wechatRelation.getOpenId(), wechatMessageDto1);
        	logger.info("公众号消息发送成功：");
        }
	}
    private String instedParams(String content, CylWarningMsgDto contingencyRo) {

//        Map<String, String> strengthMap = this.getStrengthMap(contingencyRo);
//        for (String key : strengthMap.keySet())
//            content = content.replaceAll("\\$\\{" + key + "}", strengthMap.get(key));
    	if(null == content || !content.contains("$")) {
    		return content;
    	}
          Field[] fields = contingencyRo.getClass().getDeclaredFields();
          Method getMethod = null;
          try {
              for (Field field : fields) {
                  if (field.getName().equals("serialVersionUID"))
                      continue;
                  String fileNameInMethod = String.valueOf(field.getName().charAt(0)).toUpperCase() + field.getName().substring(1);
                  getMethod = contingencyRo.getClass().getMethod("get" + fileNameInMethod);
                  String value = String.valueOf(getMethod.invoke(contingencyRo));
                  content = content.replaceAll("\\$\\{" + field.getName() + "}", value.equals("null")?"":value);
              }

              content = getNative(content);
          } catch (Exception e) {
              e.printStackTrace();
          }
        return content;
    }
    public String getNative(String str)
    {
      Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
      Matcher m = p.matcher(str);
      while (m.find())
      {
        String parameter = m.group();

        Object parametervalue = ELEvaluationContext
            .getValue(parameter.substring(1, parameter.length() - 1));
        if(parametervalue != null)
          str = str.replace(parameter,
            parametervalue != null ? parametervalue.toString() : null);
      }
      return str;
    }
}
