package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.MsgLogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.MsgLogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 消息流水表
 *
 * @author system_generator
 * @date 2022-04-20
 */
@RestController
@Api(tags = "消息流水表Api")
@RequestMapping(value = "/msg-log")
public class MsgLogController extends BaseController {

    @Autowired
    MsgLogServiceImpl msgLogServiceImpl;

    /**
     * 新增消息流水表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增消息流水表", notes = "新增消息流水表")
	public ResponseModel<MsgLogDto> save(@RequestBody MsgLogDto model) {
	    model = msgLogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新消息流水表", notes = "根据sequenceNbr更新消息流水表")
	public ResponseModel<MsgLogDto> updateBySequenceNbrMsgLog(@RequestBody MsgLogDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(msgLogServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消息流水表", notes = "根据sequenceNbr删除消息流水表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(msgLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个消息流水表",  notes = "根据sequenceNbr查询单个消息流水表")
	public ResponseModel<MsgLogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(msgLogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "消息流水表分页查询",  notes = "消息流水表分页查询")
	public ResponseModel<Page<MsgLogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<MsgLogDto> page = new Page<MsgLogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(msgLogServiceImpl.queryForMsgLogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "消息流水表列表全部数据查询",   notes = "消息流水表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MsgLogDto>> selectForList() {
	    return ResponseHelper.buildResponse(msgLogServiceImpl.queryForMsgLogList());
	}

	/**
	 * 告警数量统计
	 *
	 * @return Integer
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "告警数量统计",   notes = "告警数量统计")
	@GetMapping(value = "/count")
	public ResponseModel<Integer> countByTerminalType(
			@RequestParam(value = "terminalType",required = false) String terminalType) {
		return ResponseHelper.buildResponse(msgLogServiceImpl.countByTerminalType(terminalType));
	}
}