package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.yeejoin.amos.boot.module.tzs.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.CylinderUnitMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ICylinderUnitService;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderUnitDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 气瓶企业信息服务实现类
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Service
public class CylinderUnitServiceImpl extends BaseService<CylinderUnitDto,CylinderUnit,CylinderUnitMapper> implements ICylinderUnitService {
    /**
     * 分页查询
     */
    public Page<CylinderUnitDto> queryForCylinderUnitPage(Page<CylinderUnitDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderUnitDto> queryForCylinderUnitList()   {
        return this.queryForList("" , false);
    }

    /**
     * 获取上个月气瓶企业总量
     * @return
     */
    public Integer getLastMonthUnitTotal(String regionCode) {
        return baseMapper.getLastMonthUnitTotal(regionCode);
    }

    /**
     * 获取上上个月气瓶企业总量
     * @return
     */
    public Integer getMonthBeforeLastUnitTotal(String regionCode) {
        return baseMapper.getMonthBeforeLastUnitTotal(regionCode);
    }

    public Integer getUnitTotalByRegionCode(String regionCode) {
        return baseMapper.getUnitTotalByRegionCode(regionCode);
    }


    public Integer getWarnNum(String code) {
        return baseMapper.getWarnNum(code);
    }
}