package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author keyong
 * @title: LatentDangerFlowRecord
 * <pre>
 * @description: 隐患工作流记录表
 * </pre>
 * @date 2021/1/26 14:18
 */
@Entity
@Table(name = "p_latent_danger_flow_record")
@NamedQuery(name = "LatentDangerFlowRecord.findAll", query = "SELECT c FROM LatentDangerFlowRecord c")
@Where(clause = "deleted=0") //表示未删除的数据
@Data
public class LatentDangerFlowRecord extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "danger_id")
    private Long dangerId;

    @Column(name = "action_flag")
    private String actionFlag;

    @Column(name = "flow_task_name")
    private String flowTaskName;

    @Column(name = "flow_task_user_ids")
    private String flowTaskUserIds;

    @Column(name = "flow_task_id")
    private String flowTaskId;

    @Column(name = "excute_state")
    private Integer excuteState;

    @Column(name = "excute_user_id")
    private String excuteUserId;

    @Column(name = "excute_result")
    private String excuteResult;

    @Column(name = "remark")
    private String remark;

    @Column(name = "flow_json")
    private String flowJson;

    /**
     * 是否删除（0：否；1：是）
     */
    @Column(name = "deleted")
    private Integer deleted;

    /**
     * 记录修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "excute_department_id")
    private String excuteDepartmentId;

}
