package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * @ProjectName: amos-biz-boot
 * @Package: com.yeejoin.amos.supervision.dao.entity
 * @ClassName: PlanAudit
 * @Author: Jianqiang Gao
 * @Description: 计划审核申请表
 * @Date: 2021/9/23 9:52
 * @Version: 1.0
 */
@Entity
@Table(name = "p_plan_audit_log")
@NamedQuery(name = "PlanAuditLog.findAll", query = "SELECT p FROM PlanAuditLog p")
@Data
public class PlanAuditLog extends BasicEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 计划id（冗余）
     */
    @Column(name = "plan_id")
    private Long planId;
    /**
     * 计划审核申请主表
     */
    @Column(name = "plan_audit_id")
    private Long planAuditId;
    /**
     * 当前节点编号
     */
    @Column(name = "flow_task_id")
    private String flowTaskId;

    /**
     * 当前节点名称
     */
    @Column(name = "flow_task_name")
    private String flowTaskName;
    /**
     * 实际执行人
     */
    @Column(name = "excute_user_id")
    private String excuteUserId;
    /**
     * 执行人用户名称（冗余）
     */
    @Column(name = "excute_user_name")
    private String excuteUserName;
    /**
     * 执行状态（1：不通过；2：通过）
     */
    @Column(name = "excute_state")
    private Integer excuteState;
    /**
     * 角色名称
     */
    @Column(name = "role_name")
    private String roleName;

    /**
     * 执行结果
     */
    @Column(name = "excute_result")
    private String excuteResult;
    /**
     * 提交工作流json数据
     */
    @Column(name = "flow_json")
    private String flowJson;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
}