package com.yeejoin.amos.boot.module.tzs.api.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.api.enums.DispatchPaperEnums;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;

/**
 * 警情接警填报记录接口类
 *
 * @author litw
 * @date 2021-08-03
 */
public interface IAlertCalledService {

    /**
     *
     * 根据灾情id 查询灾情详情
     *
     * **/
    Object selectAlertCalledById( Long id);

    /**
     *
     * 根据警情返回信息，不读取缓存
     *
     * **/
    AlertCalledFormDto selectAlertCalledByIdNoCache(Long id);

    /**
     * 根据查询条件返回警情记录
     * @param workOrderNumber
     * @return
     */
    Page<AlertCalledQueryDto> queryAlertListByQueryDto(IPage<AlertCalledQueryDto> page,
                                                             @Condition(Operator.like) String workOrderNumber,
                                                             @Condition(Operator.like) String creator,
                                                             @Condition(Operator.like) String emergency,
                                                             @Condition(Operator.lt) String emergencyTimeStart,
                                                             @Condition(Operator.gt) String emergencyTimeEnd,
                                                             @Condition(Operator.like) String emergencyCall,
                                                             @Condition(Operator.like) String deviceId,
                                                             @Condition(Operator.like) String elevatorAddress,
                                                             @Condition(Operator.eq) String alertType,
                                                             @Condition(Operator.eq) String alertSource,
                                                             @Condition(Operator.eq) String alertStage,
                                                             @Condition(Operator.eq) String alertStatus);

    /**
     * 更新警情阶段信息
     * @param alertCalledVo
     * @param stage
     * @return
     */
    Boolean updateAlertStage(AlertCalledDto alertCalledVo, DispatchPaperEnums stage);
}
