package com.yeejoin.amos.supervision.business.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.supervision.business.dto.HiddenDangerImportDto;
import com.yeejoin.amos.supervision.business.service.intfc.IHiddenDangerService;
import com.yeejoin.amos.supervision.business.util.FileHelper;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;
import com.yeejoin.amos.supervision.core.framework.PersonIdentify;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Slf4j
@RestController
@Api(tags = "隐患api")
@RequestMapping(value = "api/hidden/danger")
public class HiddenDangerController extends AbstractBaseController {

    @Autowired
    IHiddenDangerService iHiddenDangerService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @PostMapping(value = "/{planId}/page-list")
    public ResponseModel pageList(
            @PathVariable String planId,
            @RequestParam(value = "pointId", required = false) Long pointId,
            @RequestParam(value = "level", required = false) String level,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page<DangerDto>(current, size);
        IPage<DangerDto> dtoList = iHiddenDangerService.pageList(page, planId, pointId, level, status);
        return ResponseHelper.buildResponse(dtoList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询隐患详情", notes = "查询隐患详情")
    @GetMapping("/{latentDangerId}")
    public ResponseModel getOne(@PathVariable Long latentDangerId) {
        DangerDto dangerDto = iHiddenDangerService.getOne(latentDangerId);
        return ResponseHelper.buildResponse(dangerDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新隐患", notes = "更新隐患")
    @PutMapping(value = "/{latentDangerId}")
    public ResponseModel updateDanger(
            @RequestBody DangerDto dangerDto,
            @PathVariable Long latentDangerId) {
        dangerDto = iHiddenDangerService.updateDanger(latentDangerId, dangerDto);
        return ResponseHelper.buildResponse(dangerDto);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/download/template")
    public void downloadTemplate(HttpServletResponse response) {
        iHiddenDangerService.templateExport(response);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @ApiOperation(value = "导入隐患", notes = "导入隐患")
    @RequestMapping(value = "/import", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public ResponseModel importDanger(
            @RequestParam(value = "planId") Long planId,
            @ApiParam(value = "导入数据文件", required = true) @RequestBody MultipartFile file) {
        List<HiddenDangerImportDto> list = FileHelper.importExcel(file, 0, 1, HiddenDangerImportDto.class);
        iHiddenDangerService.importDanger(getSelectedOrgInfo(),planId, list);
        return ResponseHelper.buildResponse("导入成功");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出指定计划的隐患", notes = "导出指定计划的隐患")
    @GetMapping(value = "{planId}/export")
    public void exportDangerList(
            @PathVariable String planId,
            @RequestParam(value = "pointId", required = false) Long pointId,
            @RequestParam(value = "level", required = false) String level,
            @RequestParam(value = "status", required = false) String status,
            HttpServletResponse response) {
        iHiddenDangerService.exportDangerData(planId, pointId, level, status, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "隐患删除")
    @DeleteMapping("{latentDangerIds}")
    public ResponseModel deleteByIds(@ApiParam(value = "隐患ids,隐患模块主键")@PathVariable String latentDangerIds){
        List<Long> ids = Arrays.stream(latentDangerIds.split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
        Boolean b = iHiddenDangerService.deleteBatch(ids);
        return ResponseHelper.buildResponse(b);
    }
}
