package com.yeejoin.amos;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.context.IotContext;


/**
 * 
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: AmosOPStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@EnableHystrix
@EnableScheduling
@SpringBootApplication(exclude={MybatisPlusAutoConfiguration.class})
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({ "org.typroject", "com.yeejoin.amos" })
@MapperScan(basePackages = { "com.yeejoin.amos.fas.business.dao.mapper","org.typroject.tyboot.*.*.face.orm.dao","com.yeejoin.amos.api.*.face.orm.dao","com.yeejoin.amos.boot.biz.common.dao.mapper" })
public class FireAutoSysApplication implements ApplicationContextAware {

	private static final Logger logger = LoggerFactory.getLogger(FireAutoSysApplication.class);

	/**
	 * 启动amosop-server
	 *
	 * @param args
	 * @throws IOException
	 * @throws URISyntaxException
	 */
	public static void main(String[] args)  throws UnknownHostException{
		    logger.info("start Service..........");
			ConfigurableApplicationContext context = SpringApplication.run(FireAutoSysApplication.class, args);
	        GlobalExceptionHandler.setAlwaysOk(true);
	        Environment env = context.getEnvironment();
	        String ip = InetAddress.getLocalHost().getHostAddress();
	        String port = env.getProperty("server.port");
	        String path = env.getProperty("server.servlet.context-path");
	        GlobalExceptionHandler.setAlwaysOk(true);
	        logger.info("\n----------------------------------------------------------\n\t" +
	                "Application Amos-Biz-Boot is running! Access URLs:\n\t" +
	                "Swagger文档: \thttp://" + ip + ":" + port + path + "/doc.html\n" +
	                "----------------------------------------------------------");
	}

	/**
	 * 获取并缓存上下文
	 */
	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		// 缓存spring上下文
		IotContext.getInstance().setApplicationContext(applicationContext);
		RsDataQueue.getInstance().start();
	}
}