package com.yeejoin.amos.boot.module.command.api.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import ch.qos.logback.core.net.SyslogOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import com.yeejoin.amos.boot.module.command.api.dto.SeismometeorologyDto;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
/**
 * @description:
 * @author: tw
 * @createDate: 2021/7/19
 */
@Component
public class SeismometeorologyDtoDao {


    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 保存对象SeismometeorologyDto
     * @param
     *
     */
    public void saveObj(SeismometeorologyDto book) {
        mongoTemplate.save(book);
    }



    /**
     *
     * 24小時预警
     *
     * **/
    public   List<SeismometeorologyDto> findCarStateByWatchSn(){
    	 System.out.println(new Date().getTime());
         Query query = new Query(Criteria.where("releaseTime").gte(getStartTime())
         		.lte(getEndTime()));
         Sort sort= Sort.by(Sort.Direction.DESC, "releaseTime");
         query.with(sort);
         List<SeismometeorologyDto> gpsList = mongoTemplate.find(query, SeismometeorologyDto.class);
         return gpsList;
    }

    /**
     *
     *当天气象预警
     *
     * **/
    public   List<SeismometeorologyDto> findDutyCarStateBy(){
       
        System.out.println(new Date().getTime());
        Query query = new Query(Criteria.where("releaseTime").gte(getStartTime())
        		.lte(getEndTime()));
        Sort sort= Sort.by(Sort.Direction.DESC, "releaseTime");
        query.with(sort);
        List<SeismometeorologyDto> gpsList = mongoTemplate.find(query, SeismometeorologyDto.class);
        return gpsList;
    }
    
    
    private static Date getStartTime() {
    	Calendar todayStart = Calendar.getInstance();
    	todayStart.set(Calendar.HOUR_OF_DAY,0);
    	todayStart.set(Calendar.MINUTE,0);
    	todayStart.set(Calendar.SECOND,0);
    	todayStart.set(Calendar.MILLISECOND,0);
    	return todayStart.getTime();
    }
     
    private static Date getEndTime() {
    	Calendar todayEnd = Calendar.getInstance();
    	todayEnd.set(Calendar.HOUR_OF_DAY,23);
    	todayEnd.set(Calendar.MINUTE,59);
    	todayEnd.set(Calendar.SECOND,59);
    	todayEnd.set(Calendar.MILLISECOND,999);
    	return todayEnd.getTime();
    }

 
}

