package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.Transient;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author keyong
 * @title: LatentDangerPatrol
 * <pre>
 * @description: 隐患巡检关系表
 * </pre>
 * @date 2021/1/26 14:51
 */
@Entity
@Table(name = "p_latent_danger_patrol")
@NamedQuery(name = "LatentDangerPatrol.findAll", query = "SELECT c FROM LatentDangerPatrol c")
@Where(clause = "deleted=0") //表示未删除的数据
@Data
public class LatentDangerPatrol extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "latent_danger_id")
    private Long latentDangerId;

    @Column(name = "point_classify_id")
    private Long pointClassifyId;

    @Column(name = "check_id")
    private Long checkId;

    @Column(name = "item_id")
    private Long itemId;

    @Column(name = "point_id")
    private Long pointId;

    @Column(name = "route_id")
    private Long routeId;

    @Column(name = "risk_factor_flow_id")
    private String riskFactorFlowId;

    @Column(name = "route_point_item_id")
    private Long routePointItemId;

    /**
     * 是否删除（0：否；1：是）
     */
    @Column(name = "deleted")
    private Integer deleted;

    /**
     * 检查类型-交大字段，只是前段显示用
     */
    @Transient private String checkType;

    /**
     * 记录修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
}
