package com.yeejoin.amos.supervision.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonBackReference;


/**
 * The persistent class for the p_route_point_item database table.
 * 
 */
@Entity
@Table(name="p_route_point_item")
@NamedQuery(name="RoutePointItem.findAll", query="SELECT r FROM RoutePointItem r")
public class RoutePointItem extends BasicEntity {
	private static final long serialVersionUID = 1L;

/**
 * 创建者
 */
	@Column(name="creator_id")
	private String creatorId;

	
	/**
	 * 排序
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 巡检点检查项id
	 */
	@Column(name="point_input_item_id")
	private long pointInputItemId;

	/**
	 * 路线点表id
	 */
	@Column(name="route_point_id")
	private long routePointId;
	
	/**
	 * 点分类id
	 */
	@Column(name="point_classify_id")
	private Long pointClassifyId;
	


	/**
	 * 前端标记是否绑定
	 */
	private boolean isBound = true;

	private RoutePoint routePoint;

	/**
	 * 标准依据
	 */
	@Column(name = "basis_json", columnDefinition = "text COMMENT '标准依据'")
	private String basisJson;
	private long pointId;
	public RoutePointItem() {
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public long getPointInputItemId() {
		return this.pointInputItemId;
	}

	public void setPointInputItemId(long pointInputItemId) {
		this.pointInputItemId = pointInputItemId;
	}

	public long getRoutePointId() {
		return this.routePointId;
	}

	public void setRoutePointId(long routePointId) {
		this.routePointId = routePointId;
	}

	@ManyToOne
	@JoinColumn(name = "routePointId", referencedColumnName = "id", updatable = false, insertable = false)
	public RoutePoint getRoutePoint() {
		return routePoint;
	}
	@JsonBackReference
	public void setRoutePoint(RoutePoint routePoint) {
		this.routePoint = routePoint;
	}
	

	public Long getPointClassifyId() {
		return pointClassifyId;
	}

	public void setPointClassifyId(Long pointClassifyId) {
		this.pointClassifyId = pointClassifyId;
	}


	public String getBasisJson() {
		return basisJson;
	}

	public void setBasisJson(String basisJson) {
		this.basisJson = basisJson;
	}
	@Transient
	public long getPointId() {
		return pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	@Transient
	public boolean getIsBound() {
		return isBound;
	}

	public void setIsBound(boolean bound) {
		isBound = bound;
	}
}