package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 知识库系统动态选项配置的分组，用于区分不同功能的字段列表
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_dynamics_group")
public class KnowledgeDynamicsGroup extends BaseEntity {


	/**
	 * 分组名称
	 */
	@TableField("GROUP_NAME")
	private String groupName;
	/**
	 * 前端配置
	 */
	@TableField("FRONT_END_CONFIG")
	private String frontEndConfig;

	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;




	/**
	 * 功能标识
	 */
	@TableField("FUNCTIONAL")
	private String functional;

	/**
	 * 业务项目标识
	 */
	@TableField("APP_KEY")
	private String appKey;
}

