package com.yeejoin.amos.maintenance.exception;

/**
 * 
 * <pre>
 * 自定义异常
 * </pre>
 *
 * @author as-youjun
 * @version $Id: YeeException.java, v 0.1 2017年7月18日 上午9:34:21 as-youjun Exp $
 */
public class YeeException extends RuntimeException {

	/**	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = -1963401137898098411L;

	private int errorCode = 0;

	public YeeException(int errorCode) {
		this.errorCode = errorCode;
	}

	public YeeException(String message, int errorCode) {
		super(message);
		this.errorCode = errorCode;
	}
	
	public YeeException(String message) {
		super(message);
	}

	public YeeException(String message, Throwable cause, int errorCode) {
		super(message, cause);
		this.errorCode = errorCode;
	}

	public YeeException(Throwable cause, int errorCode) {
		super(cause);
		this.errorCode = errorCode;
	}

	public YeeException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace,
			int errorCode) {
		super(message, cause, enableSuppression, writableStackTrace);
		this.errorCode = errorCode;
	}

	/**
	 * Getter method for property <tt>errorCode</tt>.
	 * 
	 * @return property value of errorCode
	 */
	public int getErrorCode() {
		return errorCode;
	}

	/**
	 * Setter method for property <tt>errorCode</tt>.
	 * 
	 * @param errorCode
	 *            value to be assigned to property errorCode
	 */
	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

}
