package com.yeejoin.amos.maintenance.common.enums;

public enum RiskJudgmentTaskStatusEnum {

    未开始("未开始", 0),
    进行中("进行中", 1),
    已超时("已超时", 2),
    已提交("已提交", 3),
	已审核("已审核", 4),
	已合并("已汇总", 5);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    RiskJudgmentTaskStatusEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static RiskJudgmentTaskStatusEnum getByCode(Integer code) {
        for (RiskJudgmentTaskStatusEnum l : RiskJudgmentTaskStatusEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
